/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import java.util.Objects;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.model.LogEventRequestAndResponse;
import software.xdev.mockserver.model.ObjectWithJsonToString;
import software.xdev.mockserver.model.RequestDefinition;
import software.xdev.mockserver.serialization.model.DTO;
import software.xdev.mockserver.serialization.model.HttpRequestDTO;
import software.xdev.mockserver.serialization.model.HttpResponseDTO;
import software.xdev.mockserver.serialization.model.RequestDefinitionDTO;

public class LogEventRequestAndResponseDTO
extends ObjectWithJsonToString
implements DTO<LogEventRequestAndResponse> {
    private String timestamp;
    private RequestDefinitionDTO httpRequest;
    private HttpResponseDTO httpResponse;

    public LogEventRequestAndResponseDTO() {
    }

    public LogEventRequestAndResponseDTO(LogEventRequestAndResponse httpRequestAndHttpResponse) {
        if (httpRequestAndHttpResponse != null) {
            HttpResponse httpResponse;
            RequestDefinition httpRequest = httpRequestAndHttpResponse.getHttpRequest();
            if (httpRequest instanceof HttpRequest) {
                this.httpRequest = new HttpRequestDTO((HttpRequest)httpRequest);
            }
            if ((httpResponse = httpRequestAndHttpResponse.getHttpResponse()) != null) {
                this.httpResponse = new HttpResponseDTO(httpResponse);
            }
            this.timestamp = httpRequestAndHttpResponse.getTimestamp();
        }
    }

    @Override
    public LogEventRequestAndResponse buildObject() {
        RequestDefinition httpRequest = null;
        HttpResponse httpResponse = null;
        if (this.httpRequest != null) {
            httpRequest = this.httpRequest.buildObject();
        }
        if (this.httpResponse != null) {
            httpResponse = this.httpResponse.buildObject();
        }
        return new LogEventRequestAndResponse().withHttpRequest(httpRequest).withHttpResponse(httpResponse).withTimestamp(this.timestamp);
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public RequestDefinitionDTO getHttpRequest() {
        return this.httpRequest;
    }

    public void setHttpRequest(HttpRequestDTO httpRequest) {
        this.httpRequest = httpRequest;
    }

    public HttpResponseDTO getHttpResponse() {
        return this.httpResponse;
    }

    public void setHttpResponse(HttpResponseDTO httpResponse) {
        this.httpResponse = httpResponse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogEventRequestAndResponseDTO)) {
            return false;
        }
        LogEventRequestAndResponseDTO that = (LogEventRequestAndResponseDTO)o;
        return Objects.equals(this.getTimestamp(), that.getTimestamp()) && Objects.equals(this.getHttpRequest(), that.getHttpRequest()) && Objects.equals(this.getHttpResponse(), that.getHttpResponse());
    }

    public int hashCode() {
        return Objects.hash(this.getTimestamp(), this.getHttpRequest(), this.getHttpResponse());
    }
}

