/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.verify;

import java.util.Objects;
import software.xdev.mockserver.model.ExpectationId;
import software.xdev.mockserver.model.ObjectWithJsonToString;
import software.xdev.mockserver.model.RequestDefinition;
import software.xdev.mockserver.verify.VerificationTimes;

public class Verification
extends ObjectWithJsonToString {
    private RequestDefinition httpRequest;
    private ExpectationId expectationId;
    private VerificationTimes times = VerificationTimes.atLeast(1);
    private Integer maximumNumberOfRequestToReturnInVerificationFailure;

    public static Verification verification() {
        return new Verification();
    }

    public Verification withRequest(RequestDefinition requestDefinition) {
        this.httpRequest = requestDefinition;
        return this;
    }

    public RequestDefinition getHttpRequest() {
        return this.httpRequest;
    }

    public Verification withExpectationId(ExpectationId expectationId) {
        this.expectationId = expectationId;
        return this;
    }

    public ExpectationId getExpectationId() {
        return this.expectationId;
    }

    public Verification withTimes(VerificationTimes times) {
        this.times = times;
        return this;
    }

    public VerificationTimes getTimes() {
        return this.times;
    }

    public Integer getMaximumNumberOfRequestToReturnInVerificationFailure() {
        return this.maximumNumberOfRequestToReturnInVerificationFailure;
    }

    public Verification withMaximumNumberOfRequestToReturnInVerificationFailure(Integer maximumNumberOfRequestToReturnInVerificationFailure) {
        this.maximumNumberOfRequestToReturnInVerificationFailure = maximumNumberOfRequestToReturnInVerificationFailure;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Verification)) {
            return false;
        }
        Verification that = (Verification)o;
        return Objects.equals(this.getHttpRequest(), that.getHttpRequest()) && Objects.equals(this.getExpectationId(), that.getExpectationId()) && Objects.equals(this.getTimes(), that.getTimes()) && Objects.equals(this.getMaximumNumberOfRequestToReturnInVerificationFailure(), that.getMaximumNumberOfRequestToReturnInVerificationFailure());
    }

    public int hashCode() {
        return Objects.hash(this.getHttpRequest(), this.getExpectationId(), this.getTimes(), this.getMaximumNumberOfRequestToReturnInVerificationFailure());
    }
}

