/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.formatting;

import io.netty.buffer.ByteBufUtil;
import java.util.HashMap;
import java.util.Map;

public final class StringFormatter {
    private static final Map<Integer, String> INDENTS = new HashMap<Integer, String>();

    public static StringBuilder[] indentAndToString(Object ... objects) {
        return StringFormatter.indentAndToString(1, objects);
    }

    public static StringBuilder[] indentAndToString(int indent, Object ... objects) {
        StringBuilder[] indentedObjects = new StringBuilder[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            indentedObjects[i] = new StringBuilder("\n").append("\n").append(String.valueOf(objects[i]).replaceAll("(?m)^", INDENTS.get(indent))).append("\n");
        }
        return indentedObjects;
    }

    public static String formatLogMessage(String message, Object ... arguments) {
        return StringFormatter.formatLogMessage(0, message, arguments);
    }

    public static String formatLogMessage(int indent, String message, Object ... arguments) {
        StringBuilder logMessage = new StringBuilder();
        StringBuilder[] formattedArguments = StringFormatter.indentAndToString(indent + 1, arguments);
        String[] messageParts = message.split("\\{}");
        for (int messagePartIndex = 0; messagePartIndex < messageParts.length; ++messagePartIndex) {
            logMessage.append(INDENTS.get(indent)).append(messageParts[messagePartIndex]);
            if (formattedArguments.length > 0 && formattedArguments.length > messagePartIndex) {
                logMessage.append((CharSequence)formattedArguments[messagePartIndex]);
            }
            if (messagePartIndex >= messageParts.length - 1) continue;
            logMessage.append("\n");
            if (messageParts[messagePartIndex + 1].startsWith(" ")) continue;
            logMessage.append(' ');
        }
        return logMessage.toString();
    }

    public static String formatLogMessage(String[] messageParts, Object ... arguments) {
        StringBuilder logMessage = new StringBuilder();
        StringBuilder[] formattedArguments = StringFormatter.indentAndToString(arguments);
        for (int messagePartIndex = 0; messagePartIndex < messageParts.length; ++messagePartIndex) {
            logMessage.append(messageParts[messagePartIndex]);
            if (formattedArguments.length <= 0 || formattedArguments.length <= messagePartIndex) continue;
            logMessage.append((CharSequence)formattedArguments[messagePartIndex]);
        }
        return logMessage.toString();
    }

    public static String formatBytes(byte[] bytes) {
        return String.join((CharSequence)"\n", ByteBufUtil.hexDump((byte[])bytes).split("(?<=\\G.{64})"));
    }

    private StringFormatter() {
    }

    static {
        INDENTS.put(0, "");
        INDENTS.put(1, "  ");
        INDENTS.put(2, "    ");
        INDENTS.put(3, "      ");
        INDENTS.put(4, "        ");
    }
}

