/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.codec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.NottableString;
import software.xdev.mockserver.model.Parameter;
import software.xdev.mockserver.model.Parameters;
import software.xdev.mockserver.util.StringUtils;

public class PathParametersDecoder {
    private static final Pattern PATH_VARIABLE_NAME_PATTERN = Pattern.compile("\\{[.;]?([^*]+)\\*?}");
    private static final Map<String, Pattern> PATH_VARIABLE_PARAMETER_VALUE_CACHE = Collections.synchronizedMap(new WeakHashMap());

    public NottableString normalisePathWithParametersForMatching(HttpRequest matcher) {
        String value;
        if (matcher.getPath() == null) {
            return null;
        }
        if (matcher.getPathParameters() != null && !matcher.getPathParameters().isEmpty() && (value = matcher.getPath().getValue()).contains("{")) {
            ArrayList<String> pathParts = new ArrayList<String>();
            for (String pathPart : matcher.getPath().getValue().split("/")) {
                Matcher pathParameterName = PATH_VARIABLE_NAME_PATTERN.matcher(pathPart);
                pathParts.add(pathParameterName.matches() ? ".*" : pathPart);
            }
            return NottableString.string(String.join((CharSequence)"/", pathParts) + (value.endsWith("/") ? "/" : ""));
        }
        return matcher.getPath();
    }

    public Parameters extractPathParameters(HttpRequest matcher, HttpRequest matched) {
        Parameters parsedParameters;
        Parameters parameters = parsedParameters = matched.getPathParameters() != null ? matched.getPathParameters().clone() : new Parameters(new Parameter[0]);
        if (matcher.getPathParameters() != null && !matcher.getPathParameters().isEmpty()) {
            String[] matchedPathParts;
            String[] matcherPathParts = this.getPathParts(matcher.getPath());
            if (matcherPathParts.length != (matchedPathParts = this.getPathParts(matched.getPath())).length) {
                throw new IllegalArgumentException("expected path " + matcher.getPath().getValue() + " has " + matcherPathParts.length + " parts but path " + matched.getPath().getValue() + " has " + matchedPathParts.length + " part" + (matchedPathParts.length > 1 ? "s " : " "));
            }
            for (int i = 0; i < matcherPathParts.length; ++i) {
                Matcher pathParameterName = PATH_VARIABLE_NAME_PATTERN.matcher(matcherPathParts[i]);
                if (!pathParameterName.matches()) continue;
                String parameterName = pathParameterName.group(1);
                ArrayList<String> parameterValues = new ArrayList<String>();
                Matcher pathParameterValue = PATH_VARIABLE_PARAMETER_VALUE_CACHE.computeIfAbsent(parameterName, para -> Pattern.compile("[.;]?(?:" + para + "=)?([^,]++)[.,;]?")).matcher(matchedPathParts[i]);
                while (pathParameterValue.find()) {
                    parameterValues.add(pathParameterValue.group(1));
                }
                parsedParameters.withEntry(parameterName, parameterValues);
            }
        }
        return parsedParameters;
    }

    private String[] getPathParts(NottableString path) {
        return path != null ? (String[])Arrays.stream(StringUtils.removeStart(path.getValue(), "/").split("/")).filter(StringUtils::isNotBlank).toArray(String[]::new) : new String[]{};
    }
}

