/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.formatting;

import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class StringFormatter {
    private static final Map<Integer, String> INDENTS = IntStream.rangeClosed(0, 4).boxed().collect(Collectors.toMap(Function.identity(), i -> " ".repeat(i * 2)));
    private static final Pattern PATTERN_MULTI_LINE_START = Pattern.compile("(?m)^");
    private static final Pattern PATTERN_MESSAGE_PARTS = Pattern.compile("\\{}");

    public static StringBuilder[] indentAndToString(Object ... objects) {
        return StringFormatter.indentAndToString(1, objects);
    }

    public static StringBuilder[] indentAndToString(int indent, Object ... objects) {
        StringBuilder[] indentedObjects = new StringBuilder[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            indentedObjects[i] = new StringBuilder(64).append("\n").append("\n").append(PATTERN_MULTI_LINE_START.matcher(String.valueOf(objects[i])).replaceAll(INDENTS.get(indent))).append("\n");
        }
        return indentedObjects;
    }

    public static String formatLogMessage(int indent, String message, Object ... arguments) {
        StringBuilder logMessage = new StringBuilder(16 + message.length() + arguments.length * 64);
        StringBuilder[] formattedArguments = StringFormatter.indentAndToString(indent + 1, arguments);
        String[] messageParts = PATTERN_MESSAGE_PARTS.split(message);
        for (int messagePartIndex = 0; messagePartIndex < messageParts.length; ++messagePartIndex) {
            logMessage.append(INDENTS.get(indent)).append(messageParts[messagePartIndex]);
            if (formattedArguments.length > 0 && formattedArguments.length > messagePartIndex) {
                logMessage.append((CharSequence)formattedArguments[messagePartIndex]);
            }
            if (messagePartIndex >= messageParts.length - 1) continue;
            logMessage.append("\n");
            if (messageParts[messagePartIndex + 1].startsWith(" ")) continue;
            logMessage.append(' ');
        }
        return logMessage.toString();
    }

    public static String formatLogMessage(String[] messageParts, Object ... arguments) {
        StringBuilder logMessage = new StringBuilder();
        StringBuilder[] formattedArguments = StringFormatter.indentAndToString(arguments);
        for (int messagePartIndex = 0; messagePartIndex < messageParts.length; ++messagePartIndex) {
            logMessage.append(messageParts[messagePartIndex]);
            if (formattedArguments.length <= 0 || formattedArguments.length <= messagePartIndex) continue;
            logMessage.append((CharSequence)formattedArguments[messagePartIndex]);
        }
        return logMessage.toString();
    }

    private StringFormatter() {
    }
}

