/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.logging;

import io.netty.buffer.ByteBufUtil;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Pattern;

public final class BinaryArrayFormatter {
    private static final Pattern PATTERN_FORMAT_FIXED_LENGTH = Pattern.compile("(?<=\\G.{64})");
    private static final byte[] HEX_ARRAY = "0123456789abcdef".getBytes(StandardCharsets.US_ASCII);

    public static String byteArrayToString(byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            return "base64:\n  " + BinaryArrayFormatter.formatFixedLength(Base64.getEncoder().encodeToString(bytes)) + "\nhex:\n  " + BinaryArrayFormatter.formatFixedLength(BinaryArrayFormatter.bytesToHex(bytes));
        }
        return "base64:\n\nhex:\n";
    }

    public static String formatFixedLengthHex(byte[] bytes) {
        return BinaryArrayFormatter.formatFixedLength(ByteBufUtil.hexDump((byte[])bytes));
    }

    private static String formatFixedLength(String s) {
        return String.join((CharSequence)"\n", PATTERN_FORMAT_FIXED_LENGTH.split(s));
    }

    private static String bytesToHex(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    private BinaryArrayFormatter() {
    }
}

