/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.model;

import java.util.Objects;
import software.xdev.mockserver.model.Delay;
import software.xdev.mockserver.model.ObjectWithJsonToString;

public class ConnectionOptions
extends ObjectWithJsonToString {
    private Boolean suppressContentLengthHeader;
    private Integer contentLengthHeaderOverride;
    private Boolean suppressConnectionHeader;
    private Integer chunkSize;
    private Boolean keepAliveOverride;
    private Boolean closeSocket;
    private Delay closeSocketDelay;

    public static ConnectionOptions connectionOptions() {
        return new ConnectionOptions();
    }

    public ConnectionOptions withSuppressContentLengthHeader(Boolean suppressContentLengthHeader) {
        this.suppressContentLengthHeader = suppressContentLengthHeader;
        return this;
    }

    public Boolean getSuppressContentLengthHeader() {
        return this.suppressContentLengthHeader;
    }

    public ConnectionOptions withContentLengthHeaderOverride(Integer contentLengthHeaderOverride) {
        this.contentLengthHeaderOverride = contentLengthHeaderOverride;
        return this;
    }

    public Integer getContentLengthHeaderOverride() {
        return this.contentLengthHeaderOverride;
    }

    public ConnectionOptions withSuppressConnectionHeader(Boolean suppressConnectionHeader) {
        this.suppressConnectionHeader = suppressConnectionHeader;
        return this;
    }

    public Boolean getSuppressConnectionHeader() {
        return this.suppressConnectionHeader;
    }

    public ConnectionOptions withChunkSize(Integer chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    public Integer getChunkSize() {
        return this.chunkSize;
    }

    public ConnectionOptions withKeepAliveOverride(Boolean keepAliveOverride) {
        this.keepAliveOverride = keepAliveOverride;
        return this;
    }

    public Boolean getKeepAliveOverride() {
        return this.keepAliveOverride;
    }

    public ConnectionOptions withCloseSocket(Boolean closeSocket) {
        this.closeSocket = closeSocket;
        return this;
    }

    public Boolean getCloseSocket() {
        return this.closeSocket;
    }

    public ConnectionOptions withCloseSocketDelay(Delay closeSocketDelay) {
        this.closeSocketDelay = closeSocketDelay;
        return this;
    }

    public Delay getCloseSocketDelay() {
        return this.closeSocketDelay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionOptions)) {
            return false;
        }
        ConnectionOptions that = (ConnectionOptions)o;
        return Objects.equals(this.getSuppressContentLengthHeader(), that.getSuppressContentLengthHeader()) && Objects.equals(this.getContentLengthHeaderOverride(), that.getContentLengthHeaderOverride()) && Objects.equals(this.getSuppressConnectionHeader(), that.getSuppressConnectionHeader()) && Objects.equals(this.getChunkSize(), that.getChunkSize()) && Objects.equals(this.getKeepAliveOverride(), that.getKeepAliveOverride()) && Objects.equals(this.getCloseSocket(), that.getCloseSocket()) && Objects.equals(this.getCloseSocketDelay(), that.getCloseSocketDelay());
    }

    public int hashCode() {
        return Objects.hash(this.getSuppressContentLengthHeader(), this.getContentLengthHeaderOverride(), this.getSuppressConnectionHeader(), this.getChunkSize(), this.getKeepAliveOverride(), this.getCloseSocket(), this.getCloseSocketDelay());
    }
}

