/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.model;

import java.util.Objects;
import software.xdev.mockserver.model.NottableString;
import software.xdev.mockserver.model.ObjectWithJsonToString;
import software.xdev.mockserver.util.StringUtils;

public class KeyAndValue
extends ObjectWithJsonToString {
    private final NottableString name;
    private final NottableString value;
    private final int hashCode;

    public KeyAndValue(String name, String value) {
        this(NottableString.string(name), NottableString.string(StringUtils.isBlank(value) ? "" : value));
    }

    public KeyAndValue(NottableString name, String value) {
        this(name, NottableString.string(StringUtils.isBlank(value) ? "" : value));
    }

    public KeyAndValue(NottableString name, NottableString value) {
        this.name = name;
        this.value = value;
        this.hashCode = Objects.hash(name, value);
    }

    public NottableString getName() {
        return this.name;
    }

    public NottableString getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        KeyAndValue that = (KeyAndValue)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

