/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.mockserver.model.LogEventRequestAndResponse;
import software.xdev.mockserver.serialization.JsonArraySerializer;
import software.xdev.mockserver.serialization.ObjectMapperFactory;
import software.xdev.mockserver.serialization.model.LogEventRequestAndResponseDTO;
import software.xdev.mockserver.util.StringUtils;

public class LogEventRequestAndResponseSerializer {
    private final ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private final JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();
    private static final ObjectWriter OBJECT_WRITER = ObjectMapperFactory.createObjectMapper().writer((PrettyPrinter)new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE).withObjectIndenter((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE));

    public String serialize(LogEventRequestAndResponse httpRequestAndHttpResponse) {
        try {
            return OBJECT_WRITER.writeValueAsString((Object)new LogEventRequestAndResponseDTO(httpRequestAndHttpResponse));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception while serializing HttpRequestAndHttpResponse to JSON with value " + String.valueOf(httpRequestAndHttpResponse), e);
        }
    }

    public String serialize(List<LogEventRequestAndResponse> httpRequestAndHttpResponses) {
        return this.serialize(httpRequestAndHttpResponses.toArray(new LogEventRequestAndResponse[0]));
    }

    public String serialize(LogEventRequestAndResponse ... httpRequestAndHttpResponses) {
        try {
            if (httpRequestAndHttpResponses != null && httpRequestAndHttpResponses.length > 0) {
                LogEventRequestAndResponseDTO[] httpRequestAndHttpResponseDTOS = new LogEventRequestAndResponseDTO[httpRequestAndHttpResponses.length];
                for (int i = 0; i < httpRequestAndHttpResponses.length; ++i) {
                    httpRequestAndHttpResponseDTOS[i] = new LogEventRequestAndResponseDTO(httpRequestAndHttpResponses[i]);
                }
                return OBJECT_WRITER.withDefaultPrettyPrinter().writeValueAsString((Object)httpRequestAndHttpResponseDTOS);
            }
            return "[]";
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception while serializing HttpRequestAndHttpResponse to JSON with value " + String.valueOf(Arrays.asList(httpRequestAndHttpResponses)), e);
        }
    }

    public LogEventRequestAndResponse deserialize(String jsonHttpRequestAndHttpResponse) {
        if (StringUtils.isBlank(jsonHttpRequestAndHttpResponse)) {
            throw new IllegalArgumentException("1 error:\n - a request is required but value was \"" + jsonHttpRequestAndHttpResponse + "\"");
        }
        LogEventRequestAndResponse httpRequestAndHttpResponse = null;
        try {
            LogEventRequestAndResponseDTO httpRequestAndHttpResponseDTO = (LogEventRequestAndResponseDTO)this.objectMapper.readValue(jsonHttpRequestAndHttpResponse, LogEventRequestAndResponseDTO.class);
            if (httpRequestAndHttpResponseDTO != null) {
                httpRequestAndHttpResponse = httpRequestAndHttpResponseDTO.buildObject();
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("exception while parsing [" + jsonHttpRequestAndHttpResponse + "] for HttpRequestAndHttpResponse", ex);
        }
        return httpRequestAndHttpResponse;
    }

    public LogEventRequestAndResponse[] deserializeArray(String jsonHttpRequestAndHttpResponse) {
        ArrayList<LogEventRequestAndResponse> httpRequestAndHttpResponses = new ArrayList<LogEventRequestAndResponse>();
        if (StringUtils.isBlank(jsonHttpRequestAndHttpResponse)) {
            throw new IllegalArgumentException("1 error:\n - a request or request array is required but value was \"" + jsonHttpRequestAndHttpResponse + "\"");
        }
        List<String> jsonRequestList = this.jsonArraySerializer.splitJSONArray(jsonHttpRequestAndHttpResponse);
        if (jsonRequestList.isEmpty()) {
            throw new IllegalArgumentException("1 error:\n - a request or array of request is required");
        }
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        for (String jsonRequest : jsonRequestList) {
            try {
                httpRequestAndHttpResponses.add(this.deserialize(jsonRequest));
            }
            catch (IllegalArgumentException iae) {
                validationErrorsList.add(iae.getMessage());
            }
        }
        if (!validationErrorsList.isEmpty()) {
            throw new IllegalArgumentException((validationErrorsList.size() > 1 ? "[" : "") + String.join((CharSequence)",\n", validationErrorsList) + (validationErrorsList.size() > 1 ? "]" : ""));
        }
        return httpRequestAndHttpResponses.toArray(new LogEventRequestAndResponse[0]);
    }
}

