/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.Map;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpRequestAndHttpResponse;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.serialization.HttpRequestAndHttpResponseSerializer;
import software.xdev.mockserver.serialization.HttpRequestSerializer;
import software.xdev.mockserver.serialization.HttpResponseSerializer;
import software.xdev.mockserver.serialization.ObjectMapperFactory;
import software.xdev.mockserver.serialization.Serializer;
import software.xdev.mockserver.serialization.model.WebSocketMessageDTO;

public class WebSocketMessageSerializer {
    private final ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, false, new JsonSerializer[0]);
    private final ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private final Map<Class, Serializer> serializers = Map.of(HttpRequest.class, new HttpRequestSerializer(), HttpResponse.class, new HttpResponseSerializer(), HttpRequestAndHttpResponse.class, new HttpRequestAndHttpResponseSerializer());

    public String serialize(Object message) throws JsonProcessingException {
        if (this.serializers.containsKey(message.getClass())) {
            WebSocketMessageDTO value = new WebSocketMessageDTO().setType(message.getClass().getName()).setValue(this.serializers.get(message.getClass()).serialize(message));
            return this.objectWriter.writeValueAsString((Object)value);
        }
        return this.objectWriter.writeValueAsString((Object)new WebSocketMessageDTO().setType(message.getClass().getName()).setValue(this.objectMapper.writeValueAsString(message)));
    }

    public Object deserialize(String messageJson) throws ClassNotFoundException, IOException {
        WebSocketMessageDTO webSocketMessageDTO = (WebSocketMessageDTO)this.objectMapper.readValue(messageJson, WebSocketMessageDTO.class);
        if (webSocketMessageDTO.getType() != null && webSocketMessageDTO.getValue() != null) {
            Class<?> format = Class.forName(webSocketMessageDTO.getType());
            if (this.serializers.containsKey(format)) {
                return this.serializers.get(format).deserialize(webSocketMessageDTO.getValue());
            }
            return this.objectMapper.readValue(webSocketMessageDTO.getValue(), format);
        }
        return null;
    }
}

