/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.deserializers.collections;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import software.xdev.mockserver.model.KeyMatchStyle;
import software.xdev.mockserver.model.KeysToMultiValues;
import software.xdev.mockserver.model.NottableString;
import software.xdev.mockserver.model.ParameterStyle;

public abstract class KeysToMultiValuesDeserializer<T extends KeysToMultiValues<?, ?>>
extends StdDeserializer<T> {
    KeysToMultiValuesDeserializer(Class<T> valueClass) {
        super(valueClass);
    }

    public abstract T build();

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.isExpectedStartArrayToken()) {
            return this.deserializeArray(p, ctxt);
        }
        if (p.isExpectedStartObjectToken()) {
            return this.deserializeObject(p, ctxt);
        }
        return null;
    }

    private T deserializeObject(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonToken token;
        T entries = this.build();
        NottableString key = NottableString.string("");
        block7: while (true) {
            token = jsonParser.nextToken();
            switch (token) {
                case FIELD_NAME: {
                    key = NottableString.string(jsonParser.getText());
                    if (!"keyMatchStyle".equals(key.getValue())) continue block7;
                    jsonParser.nextToken();
                    ((KeysToMultiValues)entries).withKeyMatchStyle((KeyMatchStyle)((Object)ctxt.readValue(jsonParser, KeyMatchStyle.class)));
                    continue block7;
                }
                case START_OBJECT: {
                    jsonParser.nextToken();
                    ParameterStyle parameterStyle = ParameterStyle.FORM_EXPLODED;
                    NottableString[] values = null;
                    while (token != JsonToken.END_OBJECT) {
                        String fieldName = jsonParser.currentName();
                        if ("values".equals(fieldName)) {
                            jsonParser.nextToken();
                            values = (NottableString[])ctxt.readValue(jsonParser, NottableString[].class);
                        } else if ("parameterStyle".equals(fieldName)) {
                            jsonParser.nextToken();
                            parameterStyle = (ParameterStyle)((Object)ctxt.readValue(jsonParser, ParameterStyle.class));
                        }
                        token = jsonParser.nextToken();
                    }
                    ((KeysToMultiValues)entries).withEntry(key.withStyle(parameterStyle), values);
                    continue block7;
                }
                case START_ARRAY: {
                    ((KeysToMultiValues)entries).withEntry(key, (NottableString[])ctxt.readValue(jsonParser, NottableString[].class));
                    continue block7;
                }
                case VALUE_STRING: {
                    ((KeysToMultiValues)entries).withEntry(key, (NottableString)ctxt.readValue(jsonParser, NottableString.class));
                    continue block7;
                }
                case END_OBJECT: {
                    return entries;
                }
            }
            break;
        }
        throw new RuntimeException("Unexpected token: \"" + String.valueOf(token) + "\" id: \"" + token.id() + "\" text: \"" + jsonParser.getText());
    }

    private T deserializeArray(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonToken token;
        T entries = this.build();
        NottableString key = NottableString.string("");
        NottableString[] values = null;
        block8: while (true) {
            token = jsonParser.nextToken();
            switch (token) {
                case START_ARRAY: {
                    values = (NottableString[])ctxt.readValue(jsonParser, NottableString[].class);
                    continue block8;
                }
                case END_ARRAY: {
                    return entries;
                }
                case START_OBJECT: {
                    key = key != null ? null : (NottableString)ctxt.readValue(jsonParser, NottableString.class);
                    values = null;
                    continue block8;
                }
                case END_OBJECT: {
                    ((KeysToMultiValues)entries).withEntry(key, values);
                    continue block8;
                }
                case FIELD_NAME: {
                    continue block8;
                }
                case VALUE_STRING: {
                    key = (NottableString)ctxt.readValue(jsonParser, NottableString.class);
                    continue block8;
                }
            }
            break;
        }
        throw new RuntimeException("Unexpected token: \"" + String.valueOf(token) + "\" id: \"" + token.id() + "\" text: \"" + jsonParser.getText());
    }
}

