/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import software.xdev.mockserver.model.Delay;
import software.xdev.mockserver.serialization.model.DTO;

public class DelayDTO
implements DTO<Delay> {
    private TimeUnit timeUnit;
    private long value;

    public DelayDTO(Delay delay) {
        if (delay != null) {
            this.timeUnit = delay.getTimeUnit();
            this.value = delay.getValue();
        }
    }

    public DelayDTO() {
    }

    @Override
    public Delay buildObject() {
        return new Delay(this.timeUnit, this.value);
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public DelayDTO setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    public long getValue() {
        return this.value;
    }

    public DelayDTO setValue(long value) {
        this.value = value;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DelayDTO)) {
            return false;
        }
        DelayDTO delayDTO = (DelayDTO)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.getValue() == delayDTO.getValue() && this.getTimeUnit() == delayDTO.getTimeUnit();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getTimeUnit(), this.getValue()});
    }
}

