/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import java.util.Objects;
import software.xdev.mockserver.model.CookiesModifier;
import software.xdev.mockserver.model.HeadersModifier;
import software.xdev.mockserver.model.HttpRequestModifier;
import software.xdev.mockserver.model.PathModifier;
import software.xdev.mockserver.model.QueryParametersModifier;
import software.xdev.mockserver.serialization.model.CookiesModifierDTO;
import software.xdev.mockserver.serialization.model.DTO;
import software.xdev.mockserver.serialization.model.HeadersModifierDTO;
import software.xdev.mockserver.serialization.model.QueryParametersModifierDTO;

public class HttpRequestModifierDTO
implements DTO<HttpRequestModifier> {
    private PathModifier path;
    private QueryParametersModifierDTO queryStringParameters;
    private HeadersModifierDTO headers;
    private CookiesModifierDTO cookies;

    public HttpRequestModifierDTO() {
    }

    public HttpRequestModifierDTO(HttpRequestModifier httpRequestModifier) {
        if (httpRequestModifier != null) {
            this.path = httpRequestModifier.getPath();
            this.queryStringParameters = httpRequestModifier.getQueryStringParameters() != null ? new QueryParametersModifierDTO(httpRequestModifier.getQueryStringParameters()) : null;
            this.headers = httpRequestModifier.getHeaders() != null ? new HeadersModifierDTO(httpRequestModifier.getHeaders()) : null;
            this.cookies = httpRequestModifier.getCookies() != null ? new CookiesModifierDTO(httpRequestModifier.getCookies()) : null;
        }
    }

    @Override
    public HttpRequestModifier buildObject() {
        return new HttpRequestModifier().withPath(this.path).withQueryStringParameters(this.queryStringParameters != null ? (QueryParametersModifier)this.queryStringParameters.buildObject() : null).withHeaders(this.headers != null ? (HeadersModifier)this.headers.buildObject() : null).withCookies(this.cookies != null ? (CookiesModifier)this.cookies.buildObject() : null);
    }

    public PathModifier getPath() {
        return this.path;
    }

    public HttpRequestModifierDTO setPath(PathModifier path) {
        this.path = path;
        return this;
    }

    public QueryParametersModifierDTO getQueryStringParameters() {
        return this.queryStringParameters;
    }

    public HttpRequestModifierDTO setQueryStringParameters(QueryParametersModifierDTO queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
        return this;
    }

    public HeadersModifierDTO getHeaders() {
        return this.headers;
    }

    public HttpRequestModifierDTO setHeaders(HeadersModifierDTO headers) {
        this.headers = headers;
        return this;
    }

    public CookiesModifierDTO getCookies() {
        return this.cookies;
    }

    public HttpRequestModifierDTO setCookies(CookiesModifierDTO cookies) {
        this.cookies = cookies;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpRequestModifierDTO)) {
            return false;
        }
        HttpRequestModifierDTO that = (HttpRequestModifierDTO)o;
        return Objects.equals(this.getPath(), that.getPath()) && Objects.equals(this.getQueryStringParameters(), that.getQueryStringParameters()) && Objects.equals(this.getHeaders(), that.getHeaders()) && Objects.equals(this.getCookies(), that.getCookies());
    }

    public int hashCode() {
        return Objects.hash(this.getPath(), this.getQueryStringParameters(), this.getHeaders(), this.getCookies());
    }
}

