/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import java.util.Arrays;
import java.util.Objects;
import software.xdev.mockserver.model.StringBody;
import software.xdev.mockserver.serialization.model.BodyWithContentTypeDTO;

public class StringBodyDTO
extends BodyWithContentTypeDTO {
    private final String string;
    private final boolean subString;
    private final byte[] rawBytes;

    public StringBodyDTO(StringBody stringBody) {
        this(stringBody, stringBody.getNot());
    }

    public StringBodyDTO(StringBody stringBody, Boolean not) {
        super(stringBody.getType(), not, stringBody);
        this.string = stringBody.getValue();
        this.subString = stringBody.isSubString();
        this.rawBytes = stringBody.getRawBytes();
    }

    public String getString() {
        return this.string;
    }

    public boolean isSubString() {
        return this.subString;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    @Override
    public StringBody buildObject() {
        return (StringBody)new StringBody(this.getString(), this.getRawBytes(), this.isSubString(), this.getMediaType()).withOptional(this.getOptional());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringBodyDTO)) {
            return false;
        }
        StringBodyDTO that = (StringBodyDTO)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.isSubString() == that.isSubString() && Objects.equals(this.getString(), that.getString()) && Objects.deepEquals(this.getRawBytes(), that.getRawBytes());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getString(), this.isSubString(), Arrays.hashCode(this.getRawBytes()));
    }
}

