/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import java.util.Objects;
import software.xdev.mockserver.model.ExpectationId;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.ObjectWithJsonToString;
import software.xdev.mockserver.serialization.model.DTO;
import software.xdev.mockserver.serialization.model.HttpRequestDTO;
import software.xdev.mockserver.serialization.model.RequestDefinitionDTO;
import software.xdev.mockserver.serialization.model.VerificationTimesDTO;
import software.xdev.mockserver.verify.Verification;
import software.xdev.mockserver.verify.VerificationTimes;

public class VerificationDTO
extends ObjectWithJsonToString
implements DTO<Verification> {
    private RequestDefinitionDTO httpRequest;
    private ExpectationId expectationId;
    private VerificationTimesDTO times;
    private Integer maximumNumberOfRequestToReturnInVerificationFailure;

    public VerificationDTO(Verification verification) {
        if (verification != null) {
            if (verification.getHttpRequest() instanceof HttpRequest) {
                this.httpRequest = new HttpRequestDTO((HttpRequest)verification.getHttpRequest());
            }
            this.expectationId = verification.getExpectationId();
            this.times = new VerificationTimesDTO(verification.getTimes());
            this.maximumNumberOfRequestToReturnInVerificationFailure = verification.getMaximumNumberOfRequestToReturnInVerificationFailure();
        }
    }

    public VerificationDTO() {
    }

    @Override
    public Verification buildObject() {
        return Verification.verification().withRequest(this.httpRequest != null ? this.httpRequest.buildObject() : null).withExpectationId(this.expectationId).withTimes(this.times != null ? this.times.buildObject() : VerificationTimes.once()).withMaximumNumberOfRequestToReturnInVerificationFailure(this.maximumNumberOfRequestToReturnInVerificationFailure);
    }

    public RequestDefinitionDTO getHttpRequest() {
        return this.httpRequest;
    }

    public VerificationDTO setHttpRequest(HttpRequestDTO httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    public ExpectationId getExpectationId() {
        return this.expectationId;
    }

    public VerificationDTO setExpectationId(ExpectationId expectationId) {
        this.expectationId = expectationId;
        return this;
    }

    public VerificationTimesDTO getTimes() {
        return this.times;
    }

    public VerificationDTO setTimes(VerificationTimesDTO times) {
        this.times = times;
        return this;
    }

    public Integer getMaximumNumberOfRequestToReturnInVerificationFailure() {
        return this.maximumNumberOfRequestToReturnInVerificationFailure;
    }

    public VerificationDTO setMaximumNumberOfRequestToReturnInVerificationFailure(Integer maximumNumberOfRequestToReturnInVerificationFailure) {
        this.maximumNumberOfRequestToReturnInVerificationFailure = maximumNumberOfRequestToReturnInVerificationFailure;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VerificationDTO)) {
            return false;
        }
        VerificationDTO that = (VerificationDTO)o;
        return Objects.equals(this.getHttpRequest(), that.getHttpRequest()) && Objects.equals(this.getExpectationId(), that.getExpectationId()) && Objects.equals(this.getTimes(), that.getTimes()) && Objects.equals(this.getMaximumNumberOfRequestToReturnInVerificationFailure(), that.getMaximumNumberOfRequestToReturnInVerificationFailure());
    }

    public int hashCode() {
        return Objects.hash(this.getHttpRequest(), this.getExpectationId(), this.getTimes(), this.getMaximumNumberOfRequestToReturnInVerificationFailure());
    }
}

