/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.url;

import java.util.regex.Pattern;
import software.xdev.mockserver.util.StringUtils;

public final class URLParser {
    private static final Pattern PATTERN_SCHEME_REGEX = Pattern.compile("https?://.*");
    private static final Pattern PATTERN_SCHEME_HOST_AND_PORT_REGEX = Pattern.compile("https?://([A-z0-9-_.:]*@)?[A-z0-9-_.]*(:[0-9]*)?");

    public static boolean isFullUrl(String uri) {
        return uri != null && PATTERN_SCHEME_REGEX.matcher(uri).matches();
    }

    public static String returnPath(String path) {
        return StringUtils.substringBefore(URLParser.isFullUrl(path) ? PATTERN_SCHEME_HOST_AND_PORT_REGEX.matcher(path).replaceAll("") : path, "?");
    }

    private URLParser() {
    }
}

