/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.verify;

import java.util.Objects;

public final class VerificationTimes {
    private final int atLeast;
    private final int atMost;

    private VerificationTimes(int atLeast, int atMost) {
        this.atMost = atMost;
        this.atLeast = atLeast;
    }

    public static VerificationTimes never() {
        return new VerificationTimes(0, 0);
    }

    public static VerificationTimes once() {
        return new VerificationTimes(1, 1);
    }

    public static VerificationTimes exactly(int count) {
        return new VerificationTimes(count, count);
    }

    public static VerificationTimes atLeast(int count) {
        return new VerificationTimes(count, -1);
    }

    public static VerificationTimes atMost(int count) {
        return new VerificationTimes(-1, count);
    }

    public static VerificationTimes between(int atLeast, int atMost) {
        return new VerificationTimes(atLeast, atMost);
    }

    public int getAtLeast() {
        return this.atLeast;
    }

    public int getAtMost() {
        return this.atMost;
    }

    public boolean matches(int times) {
        if (this.atLeast != -1 && times < this.atLeast) {
            return false;
        }
        return this.atMost == -1 || times <= this.atMost;
    }

    public String toString() {
        Object string = "";
        if (this.atLeast == this.atMost) {
            string = (String)string + "exactly ";
            string = this.atMost == 1 ? (String)string + "once" : (String)string + this.atMost + " times";
        } else if (this.atMost == -1) {
            string = (String)string + "at least ";
            string = this.atLeast == 1 ? (String)string + "once" : (String)string + this.atLeast + " times";
        } else if (this.atLeast == -1) {
            string = (String)string + "at most ";
            string = this.atMost == 1 ? (String)string + "once" : (String)string + this.atMost + " times";
        } else {
            string = (String)string + "between " + this.atLeast + " and " + this.atMost + " times";
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VerificationTimes)) {
            return false;
        }
        VerificationTimes that = (VerificationTimes)o;
        return this.getAtLeast() == that.getAtLeast() && this.getAtMost() == that.getAtMost();
    }

    public int hashCode() {
        return Objects.hash(this.getAtLeast(), this.getAtMost());
    }
}

