/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.configuration;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.util.StringUtils;

public class ConfigurationProperties {
    protected static final Logger LOG = LoggerFactory.getLogger(ConfigurationProperties.class);
    protected static final Pattern UNESCAPE_QUOTES_PATTERN = Pattern.compile("(^\")|(\"$)");
    protected static final String MOCKSERVER_MAX_WEB_SOCKET_EXPECTATIONS = "mockserver.maxWebSocketExpectations";
    protected static final String MOCKSERVER_CLIENT_NIO_EVENT_LOOP_THREAD_COUNT = "mockserver.clientNioEventLoopThreadCount";
    protected static final String MOCKSERVER_WEB_SOCKET_CLIENT_EVENT_LOOP_THREAD_COUNT = "mockserver.webSocketClientEventLoopThreadCount";
    protected static final String MOCKSERVER_MAX_FUTURE_TIMEOUT = "mockserver.maxFutureTimeout";
    protected static final String MOCKSERVER_MAX_SOCKET_TIMEOUT = "mockserver.maxSocketTimeout";
    protected static final String MOCKSERVER_SOCKET_CONNECTION_TIMEOUT = "mockserver.socketConnectionTimeout";
    private static final String MOCKSERVER_FORWARD_BINARY_REQUESTS_WITHOUT_WAITING_FOR_RESPONSE = "mockserver.forwardBinaryRequestsWithoutWaitingForResponse";
    protected static final String MOCKSERVER_ATTEMPT_TO_PROXY_IF_NO_MATCHING_EXPECTATION = "mockserver.attemptToProxyIfNoMatchingExpectation";
    protected static final String MOCKSERVER_FORWARD_HTTP_PROXY = "mockserver.forwardHttpProxy";
    protected static final String MOCKSERVER_FORWARD_SOCKS_PROXY = "mockserver.forwardSocksProxy";
    protected static final String MOCKSERVER_FORWARD_PROXY_AUTHENTICATION_USERNAME = "mockserver.forwardProxyAuthenticationUsername";
    protected static final String MOCKSERVER_FORWARD_PROXY_AUTHENTICATION_PASSWORD = "mockserver.forwardProxyAuthenticationPassword";
    public static Properties properties = new Properties();
    protected static Map<String, String> propertyCache;

    protected ConfigurationProperties() {
    }

    public static int maxWebSocketExpectations() {
        return ConfigurationProperties.readIntegerProperty(MOCKSERVER_MAX_WEB_SOCKET_EXPECTATIONS, "MOCKSERVER_MAX_WEB_SOCKET_EXPECTATIONS", 1500);
    }

    public static void maxWebSocketExpectations(int count) {
        ConfigurationProperties.setProperty(MOCKSERVER_MAX_WEB_SOCKET_EXPECTATIONS, String.valueOf(count));
    }

    public static int clientNioEventLoopThreadCount() {
        return ConfigurationProperties.readIntegerProperty(MOCKSERVER_CLIENT_NIO_EVENT_LOOP_THREAD_COUNT, "MOCKSERVER_CLIENT_NIO_EVENT_LOOP_THREAD_COUNT", 5);
    }

    public static void clientNioEventLoopThreadCount(int count) {
        ConfigurationProperties.setProperty(MOCKSERVER_CLIENT_NIO_EVENT_LOOP_THREAD_COUNT, String.valueOf(count));
    }

    public static int webSocketClientEventLoopThreadCount() {
        return ConfigurationProperties.readIntegerProperty(MOCKSERVER_WEB_SOCKET_CLIENT_EVENT_LOOP_THREAD_COUNT, "MOCKSERVER_WEB_SOCKET_CLIENT_EVENT_LOOP_THREAD_COUNT", 5);
    }

    public static void webSocketClientEventLoopThreadCount(int count) {
        ConfigurationProperties.setProperty(MOCKSERVER_WEB_SOCKET_CLIENT_EVENT_LOOP_THREAD_COUNT, String.valueOf(count));
    }

    public static long maxFutureTimeout() {
        return ConfigurationProperties.readLongProperty(MOCKSERVER_MAX_FUTURE_TIMEOUT, "MOCKSERVER_MAX_FUTURE_TIMEOUT", TimeUnit.SECONDS.toMillis(90L));
    }

    public static void maxFutureTimeout(long milliseconds) {
        ConfigurationProperties.setProperty(MOCKSERVER_MAX_FUTURE_TIMEOUT, String.valueOf(milliseconds));
    }

    public static long maxSocketTimeout() {
        return ConfigurationProperties.readLongProperty(MOCKSERVER_MAX_SOCKET_TIMEOUT, "MOCKSERVER_MAX_SOCKET_TIMEOUT", TimeUnit.SECONDS.toMillis(20L));
    }

    public static void maxSocketTimeout(long milliseconds) {
        ConfigurationProperties.setProperty(MOCKSERVER_MAX_SOCKET_TIMEOUT, String.valueOf(milliseconds));
    }

    public static long socketConnectionTimeout() {
        return ConfigurationProperties.readLongProperty(MOCKSERVER_SOCKET_CONNECTION_TIMEOUT, "MOCKSERVER_SOCKET_CONNECTION_TIMEOUT", TimeUnit.SECONDS.toMillis(20L));
    }

    public static void socketConnectionTimeout(long milliseconds) {
        ConfigurationProperties.setProperty(MOCKSERVER_SOCKET_CONNECTION_TIMEOUT, String.valueOf(milliseconds));
    }

    public static void forwardBinaryRequestsWithoutWaitingForResponse(boolean forwardBinaryRequestsAsynchronously) {
        ConfigurationProperties.setProperty(MOCKSERVER_FORWARD_BINARY_REQUESTS_WITHOUT_WAITING_FOR_RESPONSE, String.valueOf(forwardBinaryRequestsAsynchronously));
    }

    public static boolean forwardBinaryRequestsWithoutWaitingForResponse() {
        return Boolean.parseBoolean(ConfigurationProperties.readPropertyHierarchically(properties, MOCKSERVER_FORWARD_BINARY_REQUESTS_WITHOUT_WAITING_FOR_RESPONSE, "MOCKSERVER_FORWARD_BINARY_REQUESTS_WITHOUT_WAITING_FOR_RESPONSE", "false"));
    }

    public static boolean attemptToProxyIfNoMatchingExpectation() {
        return Boolean.parseBoolean(ConfigurationProperties.readPropertyHierarchically(properties, MOCKSERVER_ATTEMPT_TO_PROXY_IF_NO_MATCHING_EXPECTATION, "MOCKSERVER_ATTEMPT_TO_PROXY_IF_NO_MATCHING_EXPECTATION", "true"));
    }

    public static void attemptToProxyIfNoMatchingExpectation(boolean enable) {
        ConfigurationProperties.setProperty(MOCKSERVER_ATTEMPT_TO_PROXY_IF_NO_MATCHING_EXPECTATION, String.valueOf(enable));
    }

    public static InetSocketAddress forwardHttpProxy() {
        return ConfigurationProperties.readInetSocketAddressProperty(MOCKSERVER_FORWARD_HTTP_PROXY, "MOCKSERVER_FORWARD_HTTP_PROXY");
    }

    public static void forwardHttpProxy(String hostAndPort) {
        ConfigurationProperties.validateHostAndPortAndSetProperty(hostAndPort, MOCKSERVER_FORWARD_HTTP_PROXY);
    }

    public static void forwardHttpProxy(InetSocketAddress hostAndPort) {
        ConfigurationProperties.validateHostAndPortAndSetProperty(hostAndPort.toString(), MOCKSERVER_FORWARD_HTTP_PROXY);
    }

    public static InetSocketAddress forwardSocksProxy() {
        return ConfigurationProperties.readInetSocketAddressProperty(MOCKSERVER_FORWARD_SOCKS_PROXY, "MOCKSERVER_FORWARD_SOCKS_PROXY");
    }

    public static void forwardSocksProxy(String hostAndPort) {
        ConfigurationProperties.validateHostAndPortAndSetProperty(hostAndPort, MOCKSERVER_FORWARD_SOCKS_PROXY);
    }

    public static void forwardSocksProxy(InetSocketAddress hostAndPort) {
        ConfigurationProperties.validateHostAndPortAndSetProperty(hostAndPort.toString(), MOCKSERVER_FORWARD_SOCKS_PROXY);
    }

    public static String forwardProxyAuthenticationUsername() {
        return ConfigurationProperties.readPropertyHierarchically(properties, MOCKSERVER_FORWARD_PROXY_AUTHENTICATION_USERNAME, "MOCKSERVER_FORWARD_PROXY_AUTHENTICATION_USERNAME", "");
    }

    public static void forwardProxyAuthenticationUsername(String forwardProxyAuthenticationUsername) {
        if (forwardProxyAuthenticationUsername != null) {
            ConfigurationProperties.setProperty(MOCKSERVER_FORWARD_PROXY_AUTHENTICATION_USERNAME, forwardProxyAuthenticationUsername);
        } else {
            ConfigurationProperties.clearProperty(MOCKSERVER_FORWARD_PROXY_AUTHENTICATION_USERNAME);
        }
    }

    public static String forwardProxyAuthenticationPassword() {
        return ConfigurationProperties.readPropertyHierarchically(properties, MOCKSERVER_FORWARD_PROXY_AUTHENTICATION_PASSWORD, "MOCKSERVER_FORWARD_PROXY_AUTHENTICATION_PASSWORD", "");
    }

    public static void forwardProxyAuthenticationPassword(String forwardProxyAuthenticationPassword) {
        if (forwardProxyAuthenticationPassword != null) {
            ConfigurationProperties.setProperty(MOCKSERVER_FORWARD_PROXY_AUTHENTICATION_PASSWORD, forwardProxyAuthenticationPassword);
        } else {
            ConfigurationProperties.clearProperty(MOCKSERVER_FORWARD_PROXY_AUTHENTICATION_PASSWORD);
        }
    }

    protected static void validateHostAndPortAndSetProperty(String hostAndPort, String mockserverSocksProxy) {
        if (StringUtils.isBlank(hostAndPort)) {
            ConfigurationProperties.clearProperty(mockserverSocksProxy);
            return;
        }
        if (hostAndPort.startsWith("/")) {
            hostAndPort = StringUtils.substringAfter(hostAndPort, "/");
        }
        String errorMessage = "Invalid property value \"" + hostAndPort + "\" for \"" + mockserverSocksProxy + "\" must include <host>:<port> for example \"127.0.0.1:1090\" or \"localhost:1090\"";
        try {
            URI uri = new URI("https://" + hostAndPort);
            if (uri.getHost() == null || uri.getPort() == -1) {
                throw new IllegalArgumentException(errorMessage);
            }
            ConfigurationProperties.setProperty(mockserverSocksProxy, hostAndPort);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(errorMessage, ex);
        }
    }

    protected static InetSocketAddress readInetSocketAddressProperty(String key, String environmentVariableKey) {
        String[] proxyParts;
        InetSocketAddress inetSocketAddress = null;
        String proxy = ConfigurationProperties.readPropertyHierarchically(properties, key, environmentVariableKey, "");
        if (proxy != null && proxy.contains(":") && (proxyParts = proxy.split(":")).length > 1) {
            try {
                inetSocketAddress = new InetSocketAddress(proxyParts[0], Integer.parseInt(proxyParts[1]));
            }
            catch (NumberFormatException nfe) {
                LOG.error("NumberFormatException converting value \"{}\" into an integer", (Object)proxyParts[1], (Object)nfe);
            }
        }
        return inetSocketAddress;
    }

    protected static Integer readIntegerProperty(String key, String environmentVariableKey, int defaultValue) {
        try {
            return Integer.parseInt(ConfigurationProperties.readPropertyHierarchically(properties, key, environmentVariableKey, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException nfe) {
            LOG.error("NumberFormatException converting {} with value [{}]", new Object[]{key, ConfigurationProperties.readPropertyHierarchically(properties, key, environmentVariableKey, String.valueOf(defaultValue)), nfe});
            return defaultValue;
        }
    }

    protected static Long readLongProperty(String key, String environmentVariableKey, long defaultValue) {
        try {
            return Long.parseLong(ConfigurationProperties.readPropertyHierarchically(properties, key, environmentVariableKey, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException nfe) {
            LOG.error("NumberFormatException converting {} with value [{}]", new Object[]{key, ConfigurationProperties.readPropertyHierarchically(properties, key, environmentVariableKey, String.valueOf(defaultValue)), nfe});
            return defaultValue;
        }
    }

    protected static Map<String, String> getPropertyCache() {
        if (propertyCache == null) {
            propertyCache = new ConcurrentHashMap<String, String>();
        }
        return propertyCache;
    }

    protected static void setProperty(String systemPropertyKey, String value) {
        ConfigurationProperties.getPropertyCache().put(systemPropertyKey, value);
        System.setProperty(systemPropertyKey, value);
    }

    protected static void clearProperty(String systemPropertyKey) {
        ConfigurationProperties.getPropertyCache().remove(systemPropertyKey);
        System.clearProperty(systemPropertyKey);
    }

    protected static String readPropertyHierarchically(Properties properties, String systemPropertyKey, String environmentVariableKey, String defaultValue) {
        String cachedPropertyValue = ConfigurationProperties.getPropertyCache().get(systemPropertyKey);
        if (cachedPropertyValue != null) {
            return cachedPropertyValue;
        }
        if (StringUtils.isBlank(environmentVariableKey)) {
            throw new IllegalArgumentException("environment property name cannot be null for " + systemPropertyKey);
        }
        String defaultOrEnvironmentVariable = StringUtils.isNotBlank(System.getenv(environmentVariableKey)) ? System.getenv(environmentVariableKey) : defaultValue;
        String propertyValue = System.getProperty(systemPropertyKey, properties != null ? properties.getProperty(systemPropertyKey, defaultOrEnvironmentVariable) : defaultOrEnvironmentVariable);
        if (propertyValue != null && propertyValue.startsWith("\"") && propertyValue.endsWith("\"")) {
            propertyValue = UNESCAPE_QUOTES_PATTERN.matcher(propertyValue).replaceAll("");
        }
        ConfigurationProperties.getPropertyCache().put(systemPropertyKey, propertyValue);
        return propertyValue;
    }
}

