/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import software.xdev.mockserver.model.NottableString;
import software.xdev.mockserver.model.ObjectWithJsonToString;

public class PathModifier
extends ObjectWithJsonToString {
    private static final Map<String, Pattern> REGEX_PATTERN_CACHE = Collections.synchronizedMap(new WeakHashMap());
    private int hashCode;
    private String regex;
    @JsonIgnore
    private Pattern pattern;
    private String substitution;

    public String getRegex() {
        return this.regex;
    }

    public PathModifier withRegex(String regex) {
        this.regex = regex;
        this.hashCode = 0;
        return this;
    }

    public String getSubstitution() {
        return this.substitution;
    }

    public PathModifier withSubstitution(String substitution) {
        this.substitution = substitution;
        this.hashCode = 0;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        PathModifier that = (PathModifier)o;
        return Objects.equals(this.regex, that.regex) && Objects.equals(this.substitution, that.substitution);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.regex, this.substitution);
        }
        return this.hashCode;
    }

    @JsonIgnore
    private Pattern getPattern() {
        if (this.pattern == null && this.regex != null) {
            this.pattern = REGEX_PATTERN_CACHE.computeIfAbsent(this.regex, Pattern::compile);
        }
        return this.pattern;
    }

    public NottableString update(NottableString path) {
        return NottableString.string(this.update(path.getValue()), path.isNot());
    }

    public String update(String path) {
        Pattern p = this.getPattern();
        if (p != null) {
            return p.matcher(path).replaceAll(Objects.requireNonNullElse(this.substitution, ""));
        }
        return path;
    }
}

