/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class JacksonUtils {
    private static final ObjectWriter WRITER = new ObjectMapper().setNodeFactory(JsonNodeFactory.instance).enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS).enable(SerializationFeature.INDENT_OUTPUT).writer().with(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN);

    public static String prettyPrint(JsonNode node) {
        try {
            return WRITER.writeValueAsString((Object)node);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private JacksonUtils() {
    }
}

