/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import software.xdev.mockserver.serialization.JacksonUtils;
import software.xdev.mockserver.serialization.ObjectMapperFactory;

public class JsonArraySerializer {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.createObjectMapper();

    public List<String> splitJSONArray(String jsonArray) {
        return this.splitJSONArrayToJSONNodes(jsonArray).stream().map(JacksonUtils::prettyPrint).collect(Collectors.toList());
    }

    public List<JsonNode> splitJSONArrayToJSONNodes(String jsonArray) {
        ArrayList<JsonNode> arrayItems = new ArrayList<JsonNode>();
        try {
            JsonNode jsonNode = OBJECT_MAPPER.readTree(jsonArray);
            if (jsonNode instanceof ArrayNode) {
                for (JsonNode arrayElement : jsonNode) {
                    arrayItems.add(arrayElement);
                }
            } else {
                arrayItems.add(jsonNode);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return arrayItems;
    }
}

