/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import java.util.Objects;
import software.xdev.mockserver.model.HttpOverrideForwardedRequest;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpRequestModifier;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.model.HttpResponseModifier;
import software.xdev.mockserver.serialization.model.DTO;
import software.xdev.mockserver.serialization.model.DelayDTO;
import software.xdev.mockserver.serialization.model.HttpRequestDTO;
import software.xdev.mockserver.serialization.model.HttpRequestModifierDTO;
import software.xdev.mockserver.serialization.model.HttpResponseDTO;
import software.xdev.mockserver.serialization.model.HttpResponseModifierDTO;

public class HttpOverrideForwardedRequestDTO
implements DTO<HttpOverrideForwardedRequest> {
    @JsonAlias(value={"httpRequest"})
    private HttpRequestDTO requestOverride;
    private HttpRequestModifierDTO requestModifier;
    @JsonAlias(value={"httpResponse"})
    private HttpResponseDTO responseOverride;
    private HttpResponseModifierDTO responseModifier;
    private DelayDTO delay;

    public HttpOverrideForwardedRequestDTO(HttpOverrideForwardedRequest httpOverrideForwardedRequest) {
        if (httpOverrideForwardedRequest != null) {
            HttpResponseModifier modifyHttpResponse;
            HttpResponse overrideHttpResponse;
            HttpRequestModifier modifyHttpRequest;
            HttpRequest overrideHttpRequest = httpOverrideForwardedRequest.getRequestOverride();
            if (overrideHttpRequest != null) {
                this.requestOverride = new HttpRequestDTO(overrideHttpRequest);
            }
            if ((modifyHttpRequest = httpOverrideForwardedRequest.getRequestModifier()) != null) {
                this.requestModifier = new HttpRequestModifierDTO(modifyHttpRequest);
            }
            if ((overrideHttpResponse = httpOverrideForwardedRequest.getResponseOverride()) != null) {
                this.responseOverride = new HttpResponseDTO(overrideHttpResponse);
            }
            if ((modifyHttpResponse = httpOverrideForwardedRequest.getResponseModifier()) != null) {
                this.responseModifier = new HttpResponseModifierDTO(modifyHttpResponse);
            }
            this.delay = httpOverrideForwardedRequest.getDelay() != null ? new DelayDTO(httpOverrideForwardedRequest.getDelay()) : null;
        }
    }

    public HttpOverrideForwardedRequestDTO() {
    }

    @Override
    public HttpOverrideForwardedRequest buildObject() {
        HttpRequest overrideHttpRequest = null;
        if (this.requestOverride != null) {
            overrideHttpRequest = this.requestOverride.buildObject();
        }
        HttpRequestModifier modifyHttpRequest = null;
        if (this.requestModifier != null) {
            modifyHttpRequest = this.requestModifier.buildObject();
        }
        HttpResponse overrideHttpResponse = null;
        if (this.responseOverride != null) {
            overrideHttpResponse = this.responseOverride.buildObject();
        }
        HttpResponseModifier modifyHttpResponse = null;
        if (this.responseModifier != null) {
            modifyHttpResponse = this.responseModifier.buildObject();
        }
        return (HttpOverrideForwardedRequest)new HttpOverrideForwardedRequest().withRequestOverride(overrideHttpRequest).withRequestModifier(modifyHttpRequest).withResponseOverride(overrideHttpResponse).withResponseModifier(modifyHttpResponse).withDelay(this.delay != null ? this.delay.buildObject() : null);
    }

    public HttpRequestDTO getRequestOverride() {
        return this.requestOverride;
    }

    public HttpOverrideForwardedRequestDTO setRequestOverride(HttpRequestDTO requestOverride) {
        this.requestOverride = requestOverride;
        return this;
    }

    public HttpRequestModifierDTO getRequestModifier() {
        return this.requestModifier;
    }

    public HttpOverrideForwardedRequestDTO setRequestModifier(HttpRequestModifierDTO requestModifier) {
        this.requestModifier = requestModifier;
        return this;
    }

    public HttpResponseDTO getResponseOverride() {
        return this.responseOverride;
    }

    public HttpOverrideForwardedRequestDTO setResponseOverride(HttpResponseDTO responseOverride) {
        this.responseOverride = responseOverride;
        return this;
    }

    public HttpResponseModifierDTO getResponseModifier() {
        return this.responseModifier;
    }

    public HttpOverrideForwardedRequestDTO setResponseModifier(HttpResponseModifierDTO responseModifier) {
        this.responseModifier = responseModifier;
        return this;
    }

    public DelayDTO getDelay() {
        return this.delay;
    }

    public HttpOverrideForwardedRequestDTO setDelay(DelayDTO delay) {
        this.delay = delay;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpOverrideForwardedRequestDTO)) {
            return false;
        }
        HttpOverrideForwardedRequestDTO that = (HttpOverrideForwardedRequestDTO)o;
        return Objects.equals(this.getRequestOverride(), that.getRequestOverride()) && Objects.equals(this.getRequestModifier(), that.getRequestModifier()) && Objects.equals(this.getResponseOverride(), that.getResponseOverride()) && Objects.equals(this.getResponseModifier(), that.getResponseModifier()) && Objects.equals(this.getDelay(), that.getDelay());
    }

    public int hashCode() {
        return Objects.hash(this.getRequestOverride(), this.getRequestModifier(), this.getResponseOverride(), this.getResponseModifier(), this.getDelay());
    }
}

