/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.model;

import java.util.Objects;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpRequestAndHttpResponse;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.model.ObjectWithJsonToString;
import software.xdev.mockserver.serialization.model.DTO;
import software.xdev.mockserver.serialization.model.HttpRequestDTO;
import software.xdev.mockserver.serialization.model.HttpResponseDTO;

public class HttpRequestAndHttpResponseDTO
extends ObjectWithJsonToString
implements DTO<HttpRequestAndHttpResponse> {
    private HttpRequestDTO httpRequest;
    private HttpResponseDTO httpResponse;

    public HttpRequestAndHttpResponseDTO() {
    }

    public HttpRequestAndHttpResponseDTO(HttpRequestAndHttpResponse httpRequestAndHttpResponse) {
        if (httpRequestAndHttpResponse != null) {
            HttpResponse httpResponse;
            HttpRequest httpRequest = httpRequestAndHttpResponse.getHttpRequest();
            if (httpRequest != null) {
                this.httpRequest = new HttpRequestDTO(httpRequest);
            }
            if ((httpResponse = httpRequestAndHttpResponse.getHttpResponse()) != null) {
                this.httpResponse = new HttpResponseDTO(httpResponse);
            }
        }
    }

    @Override
    public HttpRequestAndHttpResponse buildObject() {
        HttpRequest httpRequest = null;
        HttpResponse httpResponse = null;
        if (this.httpRequest != null) {
            httpRequest = this.httpRequest.buildObject();
        }
        if (this.httpResponse != null) {
            httpResponse = this.httpResponse.buildObject();
        }
        return new HttpRequestAndHttpResponse().withHttpRequest(httpRequest).withHttpResponse(httpResponse);
    }

    public HttpRequestDTO getHttpRequest() {
        return this.httpRequest;
    }

    public HttpRequestAndHttpResponseDTO setHttpRequest(HttpRequestDTO httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    public HttpResponseDTO getHttpResponse() {
        return this.httpResponse;
    }

    public HttpRequestAndHttpResponseDTO setHttpResponse(HttpResponseDTO httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpRequestAndHttpResponseDTO)) {
            return false;
        }
        HttpRequestAndHttpResponseDTO that = (HttpRequestAndHttpResponseDTO)o;
        return Objects.equals(this.getHttpRequest(), that.getHttpRequest()) && Objects.equals(this.getHttpResponse(), that.getHttpResponse());
    }

    public int hashCode() {
        return Objects.hash(this.getHttpRequest(), this.getHttpResponse());
    }
}

