/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.fileoperations;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.Serializable;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.DataBoundConstructor;
import sp.sd.fileoperations.FileOperation;
import sp.sd.fileoperations.FileOperationDescriptor;

public class FileTransformOperation
extends FileOperation
implements Serializable {
    private final String includes;
    private final String excludes;

    @DataBoundConstructor
    public FileTransformOperation(String includes, String excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean runOperation(Run<?, ?> run, FilePath buildWorkspace, Launcher launcher, TaskListener listener) {
        boolean result = false;
        try {
            listener.getLogger().println("File Transform Operation:");
            EnvVars envVars = run.getEnvironment(listener);
            try {
                FilePath ws = new FilePath(buildWorkspace, ".");
                result = (Boolean)ws.act((FilePath.FileCallable)new TargetFileCallable(listener, envVars.expand(this.includes), envVars.expand(this.excludes), envVars));
            }
            catch (Exception e) {
                listener.fatalError(e.getMessage());
                return false;
            }
        }
        catch (Exception e) {
            listener.fatalError(e.getMessage());
        }
        return result;
    }

    @Extension
    @Symbol(value={"fileTransformOperation"})
    public static class DescriptorImpl
    extends FileOperationDescriptor {
        public String getDisplayName() {
            return "File Transform";
        }
    }

    private static final class TargetFileCallable
    implements FilePath.FileCallable<Boolean> {
        private static final long serialVersionUID = 1L;
        private final TaskListener listener;
        private final EnvVars environment;
        private final String resolvedIncludes;
        private final String resolvedExcludes;

        public TargetFileCallable(TaskListener Listener, String ResolvedIncludes, String ResolvedExcludes, EnvVars environment) {
            this.listener = Listener;
            this.resolvedIncludes = ResolvedIncludes;
            this.resolvedExcludes = ResolvedExcludes;
            this.environment = environment;
        }

        public Boolean invoke(File ws, VirtualChannel channel) {
            boolean result = false;
            try {
                FilePath fpWS = new FilePath(ws);
                FilePath[] resolvedFiles = fpWS.list(this.resolvedIncludes, this.resolvedExcludes);
                if (resolvedFiles.length == 0) {
                    this.listener.getLogger().println("0 files found for include pattern '" + this.resolvedIncludes + "' and exclude pattern '" + this.resolvedExcludes + "'");
                    result = true;
                } else {
                    for (FilePath item : resolvedFiles) {
                        this.listener.getLogger().println("Transforming: " + item.getRemote());
                        String fileContent = item.readToString();
                        item.deleteContents();
                        item.write(this.environment.expand(fileContent), "UTF-8");
                        result = true;
                    }
                }
            }
            catch (RuntimeException e) {
                this.listener.fatalError(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.listener.fatalError(e.getMessage());
                result = false;
            }
            return result;
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }
}

