/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.internal.format;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.measure.format.UnitFormat;
import javax.measure.spi.UnitFormatService;
import tec.uom.lib.common.function.IntPrioritySupplier;
import tec.uom.se.format.EBNFUnitFormat;
import tec.uom.se.format.LocalUnitFormat;
import tec.uom.se.format.SimpleUnitFormat;

public class DefaultUnitFormatService
implements UnitFormatService,
IntPrioritySupplier {
    static final int PRIO = 1000;
    private static final String DEFAULT_FORMAT = SimpleUnitFormat.Flavor.Default.name();
    private final Map<String, UnitFormat> formats = new HashMap<String, UnitFormat>();

    public DefaultUnitFormatService() {
        this.formats.put(DEFAULT_FORMAT, SimpleUnitFormat.getInstance());
        this.formats.put(SimpleUnitFormat.Flavor.ASCII.name(), SimpleUnitFormat.getInstance(SimpleUnitFormat.Flavor.ASCII));
        this.formats.put("EBNF", EBNFUnitFormat.getInstance());
        this.formats.put("Local", LocalUnitFormat.getInstance());
    }

    public UnitFormat getUnitFormat(String formatName) {
        Objects.requireNonNull(formatName, "Format name required");
        return this.formats.get(formatName);
    }

    public UnitFormat getUnitFormat() {
        return this.getUnitFormat(DEFAULT_FORMAT);
    }

    public Set<String> getAvailableFormatNames() {
        return this.formats.keySet();
    }

    public int getPriority() {
        return 1000;
    }
}

