/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class NullRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`NullRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with (possibly) null values.\n[Source](https://error-prone.picnic.tech/refasterrules/NullRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new IsNullRecipe(), new IsNotNullRecipe(), new RequireNonNullElseRecipe(), new RequireNonNullElseGetRecipe(), new IsNullFunctionRecipe(), new NonNullFunctionRecipe()});
    }

    @NullMarked
    public static class IsNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `NullRules.IsNull`";
        }

        public String getDescription() {
            return "Prefer the `==` operator (with `null` as the second operand) over `Objects#isNull(Object)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"null == #{object:any(java.lang.Object)}").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jspecify-1"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{object:any(java.lang.Object)} == null").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jspecify-1"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Objects.isNull(#{object:any(java.lang.Object)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jspecify-1"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Objects");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{object:any(java.lang.Object)} == null").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jspecify-1"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"null == #{object:any(java.lang.Object)}").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jspecify-1"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{object:any(java.lang.Object)} == null").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jspecify-1"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Objects.isNull(#{object:any(java.lang.Object)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jspecify-1"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Objects");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{object:any(java.lang.Object)} == null").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jspecify-1"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
        }
    }

    @NullMarked
    public static class IsNotNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `NullRules.IsNotNull`";
        }

        public String getDescription() {
            return "Prefer the `!=` operator (with `null` as the second operand) over `Objects#nonNull(Object)`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            return new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"null != #{object:any(java.lang.Object)}").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jspecify-1"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{object:any(java.lang.Object)} != null").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jspecify-1"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Objects.nonNull(#{object:any(java.lang.Object)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jspecify-1"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Objects");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{object:any(java.lang.Object)} != null").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jspecify-1"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"null != #{object:any(java.lang.Object)}").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jspecify-1"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{object:any(java.lang.Object)} != null").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jspecify-1"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Objects.nonNull(#{object:any(java.lang.Object)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jspecify-1"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Objects");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{object:any(java.lang.Object)} != null").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jspecify-1"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
        }
    }

    @NullMarked
    public static class RequireNonNullElseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `NullRules.RequireNonNullElse`";
        }

        public String getDescription() {
            return "Prefer `Objects#requireNonNullElse(Object, Object)` over non-JDK or more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.base.MoreObjects.firstNonNull(#{first:any(T)}, #{second:any(T)})").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("com.google.common.base.MoreObjects");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects.requireNonNullElse(#{first:any(T)}, #{second:any(T)})").bindType("T").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Optional.ofNullable(#{first:any(T)}).orElse(#{second:any(T)})").bindType("T").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Optional");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects.requireNonNullElse(#{first:any(T)}, #{second:any(T)})").bindType("T").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.base.MoreObjects", Boolean.valueOf(true)), new UsesMethod("com.google.common.base.MoreObjects firstNonNull(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesMethod("java.util.Optional ofNullable(..)", true), new UsesMethod("java.util.Optional orElse(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class RequireNonNullElseGetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `NullRules.RequireNonNullElseGet`";
        }

        public String getDescription() {
            return "Prefer `Objects#requireNonNullElseGet(Object, Supplier)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.Optional.ofNullable(#{object:any(T)}).orElseGet(#{supplier:any(java.util.function.Supplier<S>)})").bindType("T").genericTypes(new String[]{"T", "S extends T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Optional");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects.requireNonNullElseGet(#{object:any(T)}, #{supplier:any(java.util.function.Supplier<S>)})").bindType("T").genericTypes(new String[]{"T", "S extends T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("java.util.function.Supplier", Boolean.valueOf(true)), new UsesMethod("java.util.Optional ofNullable(..)", true), new UsesMethod("java.util.Optional orElseGet(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IsNullFunctionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `NullRules.IsNullFunction`";
        }

        public String getDescription() {
            return "Prefer `Objects#isNull(Object)` over the equivalent lambda function or more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitLambda(J.Lambda elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"(o)->o == null").bindType("java.util.function.Predicate<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects::isNull").bindType("java.util.function.Predicate<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.function.Predicate.not(java.util.Objects::nonNull)").bindType("java.util.function.Predicate<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.function.Predicate");
                        this.maybeRemoveImport("java.util.function.Predicate.not");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects::isNull").bindType("java.util.function.Predicate<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitLambda(elem, (Object)ctx);
                }

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"(o)->o == null").bindType("java.util.function.Predicate<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects::isNull").bindType("java.util.function.Predicate<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.function.Predicate.not(java.util.Objects::nonNull)").bindType("java.util.function.Predicate<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.function.Predicate");
                        this.maybeRemoveImport("java.util.function.Predicate.not");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects::isNull").bindType("java.util.function.Predicate<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class NonNullFunctionRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `NullRules.NonNullFunction`";
        }

        public String getDescription() {
            return "Prefer `Objects#nonNull(Object)` over the equivalent lambda function or more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitLambda(J.Lambda elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"(o)->o != null").bindType("java.util.function.Predicate<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects::nonNull").bindType("java.util.function.Predicate<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.function.Predicate.not(java.util.Objects::isNull)").bindType("java.util.function.Predicate<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.function.Predicate");
                        this.maybeRemoveImport("java.util.function.Predicate.not");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects::nonNull").bindType("java.util.function.Predicate<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitLambda(elem, (Object)ctx);
                }

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"(o)->o != null").bindType("java.util.function.Predicate<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects::nonNull").bindType("java.util.function.Predicate<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.function.Predicate.not(java.util.Objects::isNull)").bindType("java.util.function.Predicate<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.function.Predicate");
                        this.maybeRemoveImport("java.util.function.Predicate.not");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects::nonNull").bindType("java.util.function.Predicate<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), (TreeVisitor)javaVisitor);
        }
    }
}

