/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.io.File;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

final class AssertJFileRules {
    private AssertJFileRules() {
    }

    static final class AssertThatHasExtension {
        AssertThatHasExtension() {
        }

        AbstractStringAssert<?> before(File actual, String expectedExtension) {
            return (AbstractStringAssert)Assertions.assertThat((String)((String)Refaster.anyOf((Object[])new String[]{actual.getName(), actual.toString()}))).endsWith((CharSequence)Refaster.anyOf((Object[])new String[]{"." + expectedExtension, "." + expectedExtension}));
        }

        AbstractFileAssert<?> after(File actual, String expectedExtension) {
            return Assertions.assertThat((File)actual).hasExtension(expectedExtension);
        }
    }

    static final class AssertThatHasNoParent {
        AssertThatHasNoParent() {
        }

        void before(File actual) {
            Assertions.assertThat((String)actual.getParent()).isNull();
        }

        void after(File actual) {
            Assertions.assertThat((File)actual).hasNoParent();
        }
    }

    static final class AssertThatHasParentString {
        AssertThatHasParentString() {
        }

        AbstractFileAssert<?> before(File actual, String expected) {
            return Assertions.assertThat((File)actual.getParentFile()).hasFileName(expected);
        }

        AbstractFileAssert<?> after(File actual, String expected) {
            return Assertions.assertThat((File)actual).hasParent(expected);
        }
    }

    static final class AssertThatHasParentFile {
        AssertThatHasParentFile() {
        }

        AbstractFileAssert<?> before(File actual, File expected) {
            return (AbstractFileAssert)Assertions.assertThat((File)actual.getParentFile()).isEqualTo((Object)expected);
        }

        AbstractFileAssert<?> after(File actual, File expected) {
            return Assertions.assertThat((File)actual).hasParent(expected);
        }
    }

    static final class AssertThatHasFileName {
        AssertThatHasFileName() {
        }

        AbstractStringAssert<?> before(File actual, String fileName) {
            return Assertions.assertThat((String)actual.getName()).isEqualTo(fileName);
        }

        AbstractFileAssert<?> after(File actual, String fileName) {
            return Assertions.assertThat((File)actual).hasFileName(fileName);
        }
    }

    static final class AssertThatIsExecutable {
        AssertThatIsExecutable() {
        }

        AbstractBooleanAssert<?> before(File actual) {
            return Assertions.assertThat((boolean)actual.canExecute()).isTrue();
        }

        AbstractFileAssert<?> after(File actual) {
            return Assertions.assertThat((File)actual).isExecutable();
        }
    }

    static final class AssertThatIsWritable {
        AssertThatIsWritable() {
        }

        AbstractBooleanAssert<?> before(File actual) {
            return Assertions.assertThat((boolean)actual.canWrite()).isTrue();
        }

        AbstractFileAssert<?> after(File actual) {
            return Assertions.assertThat((File)actual).isWritable();
        }
    }

    static final class AssertThatIsReadable {
        AssertThatIsReadable() {
        }

        AbstractBooleanAssert<?> before(File actual) {
            return Assertions.assertThat((boolean)actual.canRead()).isTrue();
        }

        AbstractFileAssert<?> after(File actual) {
            return Assertions.assertThat((File)actual).isReadable();
        }
    }

    static final class AssertThatIsRelative {
        AssertThatIsRelative() {
        }

        AbstractBooleanAssert<?> before(File actual) {
            return Assertions.assertThat((boolean)actual.isAbsolute()).isFalse();
        }

        AbstractFileAssert<?> after(File actual) {
            return Assertions.assertThat((File)actual).isRelative();
        }
    }

    static final class AssertThatIsAbsolute {
        AssertThatIsAbsolute() {
        }

        AbstractBooleanAssert<?> before(File actual) {
            return Assertions.assertThat((boolean)actual.isAbsolute()).isTrue();
        }

        AbstractFileAssert<?> after(File actual) {
            return Assertions.assertThat((File)actual).isAbsolute();
        }
    }

    static final class AssertThatIsDirectory {
        AssertThatIsDirectory() {
        }

        AbstractBooleanAssert<?> before(File actual) {
            return Assertions.assertThat((boolean)actual.isDirectory()).isTrue();
        }

        AbstractFileAssert<?> after(File actual) {
            return Assertions.assertThat((File)actual).isDirectory();
        }
    }

    static final class AssertThatIsFile {
        AssertThatIsFile() {
        }

        AbstractBooleanAssert<?> before(File actual) {
            return Assertions.assertThat((boolean)actual.isFile()).isTrue();
        }

        AbstractFileAssert<?> after(File actual) {
            return Assertions.assertThat((File)actual).isFile();
        }
    }

    static final class AssertThatDoesNotExist {
        AssertThatDoesNotExist() {
        }

        AbstractBooleanAssert<?> before(File actual) {
            return Assertions.assertThat((boolean)actual.exists()).isFalse();
        }

        AbstractFileAssert<?> after(File actual) {
            return Assertions.assertThat((File)actual).doesNotExist();
        }
    }

    static final class AssertThatExists {
        AssertThatExists() {
        }

        AbstractBooleanAssert<?> before(File actual) {
            return Assertions.assertThat((boolean)actual.exists()).isTrue();
        }

        AbstractFileAssert<?> after(File actual) {
            return Assertions.assertThat((File)actual).exists();
        }
    }
}

