/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractByteAssert;
import org.assertj.core.api.AbstractCharacterAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractShortAssert;
import org.assertj.core.api.Assertions;

final class AssertJPrimitiveRules {
    private AssertJPrimitiveRules() {
    }

    static final class AssertThatIsGreaterThanOrEqualTo {
        AssertThatIsGreaterThanOrEqualTo() {
        }

        AbstractBooleanAssert<?> before(double actual, double expected) {
            return (AbstractBooleanAssert)Refaster.anyOf((Object[])new AbstractBooleanAssert[]{Assertions.assertThat((actual >= expected ? 1 : 0) != 0).isTrue(), Assertions.assertThat((actual < expected ? 1 : 0) != 0).isFalse()});
        }

        AbstractDoubleAssert<?> after(double actual, double expected) {
            return Assertions.assertThat((double)actual).isGreaterThanOrEqualTo(expected);
        }
    }

    static final class AssertThatIsGreaterThan {
        AssertThatIsGreaterThan() {
        }

        AbstractBooleanAssert<?> before(double actual, double expected) {
            return (AbstractBooleanAssert)Refaster.anyOf((Object[])new AbstractBooleanAssert[]{Assertions.assertThat((actual > expected ? 1 : 0) != 0).isTrue(), Assertions.assertThat((actual <= expected ? 1 : 0) != 0).isFalse()});
        }

        AbstractDoubleAssert<?> after(double actual, double expected) {
            return Assertions.assertThat((double)actual).isGreaterThan(expected);
        }
    }

    static final class AssertThatIsLessThanOrEqualTo {
        AssertThatIsLessThanOrEqualTo() {
        }

        AbstractBooleanAssert<?> before(double actual, double expected) {
            return (AbstractBooleanAssert)Refaster.anyOf((Object[])new AbstractBooleanAssert[]{Assertions.assertThat((actual <= expected ? 1 : 0) != 0).isTrue(), Assertions.assertThat((actual > expected ? 1 : 0) != 0).isFalse()});
        }

        AbstractDoubleAssert<?> after(double actual, double expected) {
            return Assertions.assertThat((double)actual).isLessThanOrEqualTo(expected);
        }
    }

    static final class AssertThatIsLessThan {
        AssertThatIsLessThan() {
        }

        AbstractBooleanAssert<?> before(double actual, double expected) {
            return (AbstractBooleanAssert)Refaster.anyOf((Object[])new AbstractBooleanAssert[]{Assertions.assertThat((actual < expected ? 1 : 0) != 0).isTrue(), Assertions.assertThat((actual >= expected ? 1 : 0) != 0).isFalse()});
        }

        AbstractDoubleAssert<?> after(double actual, double expected) {
            return Assertions.assertThat((double)actual).isLessThan(expected);
        }
    }

    static final class AssertThatIsNotEqualTo {
        AssertThatIsNotEqualTo() {
        }

        AbstractBooleanAssert<?> before(boolean actual, boolean expected) {
            return (AbstractBooleanAssert)Refaster.anyOf((Object[])new AbstractBooleanAssert[]{(AbstractBooleanAssert)Assertions.assertThat((boolean)actual).isNotSameAs((Object)expected), (AbstractBooleanAssert)Assertions.assertThat((boolean)actual).isNotSameAs((Object)expected)});
        }

        AbstractByteAssert<?> before(byte actual, byte expected) {
            return (AbstractByteAssert)Refaster.anyOf((Object[])new AbstractByteAssert[]{(AbstractByteAssert)Assertions.assertThat((byte)actual).isNotSameAs((Object)expected), (AbstractByteAssert)Assertions.assertThat((byte)actual).isNotSameAs((Object)expected)});
        }

        AbstractCharacterAssert<?> before(char actual, char expected) {
            return (AbstractCharacterAssert)Refaster.anyOf((Object[])new AbstractCharacterAssert[]{(AbstractCharacterAssert)Assertions.assertThat((char)actual).isNotSameAs((Object)Character.valueOf(expected)), (AbstractCharacterAssert)Assertions.assertThat((char)actual).isNotSameAs((Object)Character.valueOf(expected))});
        }

        AbstractShortAssert<?> before(short actual, short expected) {
            return (AbstractShortAssert)Refaster.anyOf((Object[])new AbstractShortAssert[]{(AbstractShortAssert)Assertions.assertThat((short)actual).isNotSameAs((Object)expected), (AbstractShortAssert)Assertions.assertThat((short)actual).isNotSameAs((Object)expected)});
        }

        AbstractIntegerAssert<?> before(int actual, int expected) {
            return (AbstractIntegerAssert)Refaster.anyOf((Object[])new AbstractIntegerAssert[]{(AbstractIntegerAssert)Assertions.assertThat((int)actual).isNotSameAs((Object)expected), (AbstractIntegerAssert)Assertions.assertThat((int)actual).isNotSameAs((Object)expected)});
        }

        AbstractLongAssert<?> before(long actual, long expected) {
            return (AbstractLongAssert)Refaster.anyOf((Object[])new AbstractLongAssert[]{(AbstractLongAssert)Assertions.assertThat((long)actual).isNotSameAs((Object)expected), (AbstractLongAssert)Assertions.assertThat((long)actual).isNotSameAs((Object)expected)});
        }

        AbstractFloatAssert<?> before(float actual, float expected) {
            return (AbstractFloatAssert)Refaster.anyOf((Object[])new AbstractFloatAssert[]{(AbstractFloatAssert)Assertions.assertThat((float)actual).isNotSameAs((Object)Float.valueOf(expected)), (AbstractFloatAssert)Assertions.assertThat((float)actual).isNotSameAs((Object)Float.valueOf(expected))});
        }

        AbstractDoubleAssert<? extends AbstractDoubleAssert<?>> before(double actual, double expected) {
            return (AbstractDoubleAssert)Refaster.anyOf((Object[])new AbstractDoubleAssert[]{(AbstractDoubleAssert)Assertions.assertThat((double)actual).isNotSameAs((Object)expected), (AbstractDoubleAssert)Assertions.assertThat((double)actual).isNotSameAs((Object)expected)});
        }

        AbstractBooleanAssert<?> after(boolean actual, boolean expected) {
            return Assertions.assertThat((boolean)actual).isNotEqualTo(expected);
        }
    }

    static final class AssertThatIsEqualTo {
        AssertThatIsEqualTo() {
        }

        AbstractBooleanAssert<?> before(boolean actual, boolean expected) {
            return (AbstractBooleanAssert)Refaster.anyOf((Object[])new AbstractBooleanAssert[]{(AbstractBooleanAssert)Assertions.assertThat((boolean)actual).isSameAs((Object)expected), (AbstractBooleanAssert)Assertions.assertThat((boolean)actual).isSameAs((Object)expected)});
        }

        AbstractByteAssert<?> before(byte actual, byte expected) {
            return (AbstractByteAssert)Refaster.anyOf((Object[])new AbstractByteAssert[]{(AbstractByteAssert)Assertions.assertThat((byte)actual).isSameAs((Object)expected), (AbstractByteAssert)Assertions.assertThat((byte)actual).isSameAs((Object)expected)});
        }

        AbstractCharacterAssert<?> before(char actual, char expected) {
            return (AbstractCharacterAssert)Refaster.anyOf((Object[])new AbstractCharacterAssert[]{(AbstractCharacterAssert)Assertions.assertThat((char)actual).isSameAs((Object)Character.valueOf(expected)), (AbstractCharacterAssert)Assertions.assertThat((char)actual).isSameAs((Object)Character.valueOf(expected))});
        }

        AbstractShortAssert<?> before(short actual, short expected) {
            return (AbstractShortAssert)Refaster.anyOf((Object[])new AbstractShortAssert[]{(AbstractShortAssert)Assertions.assertThat((short)actual).isSameAs((Object)expected), (AbstractShortAssert)Assertions.assertThat((short)actual).isSameAs((Object)expected)});
        }

        AbstractIntegerAssert<?> before(int actual, int expected) {
            return (AbstractIntegerAssert)Refaster.anyOf((Object[])new AbstractIntegerAssert[]{(AbstractIntegerAssert)Assertions.assertThat((int)actual).isSameAs((Object)expected), (AbstractIntegerAssert)Assertions.assertThat((int)actual).isSameAs((Object)expected)});
        }

        AbstractLongAssert<?> before(long actual, long expected) {
            return (AbstractLongAssert)Refaster.anyOf((Object[])new AbstractLongAssert[]{(AbstractLongAssert)Assertions.assertThat((long)actual).isSameAs((Object)expected), (AbstractLongAssert)Assertions.assertThat((long)actual).isSameAs((Object)expected)});
        }

        AbstractFloatAssert<?> before(float actual, float expected) {
            return (AbstractFloatAssert)Refaster.anyOf((Object[])new AbstractFloatAssert[]{(AbstractFloatAssert)Assertions.assertThat((float)actual).isSameAs((Object)Float.valueOf(expected)), (AbstractFloatAssert)Assertions.assertThat((float)actual).isSameAs((Object)Float.valueOf(expected))});
        }

        AbstractDoubleAssert<?> before(double actual, double expected) {
            return (AbstractDoubleAssert)Refaster.anyOf((Object[])new AbstractDoubleAssert[]{(AbstractDoubleAssert)Assertions.assertThat((double)actual).isSameAs((Object)expected), (AbstractDoubleAssert)Assertions.assertThat((double)actual).isSameAs((Object)expected)});
        }

        AbstractBooleanAssert<?> after(boolean actual, boolean expected) {
            return Assertions.assertThat((boolean)actual).isEqualTo(expected);
        }
    }
}

