/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

final class FileRules {
    private FileRules() {
    }

    static final class FilesNewBufferedReaderToPathWithCharset {
        FilesNewBufferedReaderToPathWithCharset() {
        }

        BufferedReader before(File file, Charset charset) throws FileNotFoundException {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
        }

        BufferedReader after(File file, Charset charset) throws IOException {
            return Files.newBufferedReader(file.toPath(), charset);
        }
    }

    static final class FilesNewBufferedReaderPathOfWithCharset {
        FilesNewBufferedReaderPathOfWithCharset() {
        }

        BufferedReader before(String path, Charset charset) throws FileNotFoundException {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), charset));
        }

        BufferedReader after(String path, Charset charset) throws IOException {
            return Files.newBufferedReader(Path.of(path, new String[0]), charset);
        }
    }

    static final class FilesNewBufferedReaderToPath {
        FilesNewBufferedReaderToPath() {
        }

        BufferedReader before(File file) throws IOException {
            return (BufferedReader)Refaster.anyOf((Object[])new BufferedReader[]{Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8), new BufferedReader(new InputStreamReader(new FileInputStream(file)))});
        }

        BufferedReader after(File file) throws IOException {
            return Files.newBufferedReader(file.toPath());
        }
    }

    static final class FilesNewBufferedReaderPathOf {
        FilesNewBufferedReaderPathOf() {
        }

        BufferedReader before(String path) throws IOException {
            return (BufferedReader)Refaster.anyOf((Object[])new BufferedReader[]{Files.newBufferedReader(Path.of(path, new String[0]), StandardCharsets.UTF_8), new BufferedReader(new InputStreamReader(new FileInputStream(path)))});
        }

        BufferedReader after(String path) throws IOException {
            return Files.newBufferedReader(Path.of(path, new String[0]));
        }
    }

    static final class FileMkDirsFileExists {
        FileMkDirsFileExists() {
        }

        boolean before(File file) {
            return file.exists() || file.mkdirs();
        }

        boolean after(File file) {
            return file.mkdirs() || file.exists();
        }
    }

    static final class PathToFileMkDirsFilesExists {
        PathToFileMkDirsFilesExists() {
        }

        boolean before(Path path) {
            return Files.exists(path, new LinkOption[0]) || path.toFile().mkdirs();
        }

        boolean after(Path path) {
            return path.toFile().mkdirs() || Files.exists(path, new LinkOption[0]);
        }
    }

    static final class FilesCreateTempFileInCustomDirectoryToFile {
        FilesCreateTempFileInCustomDirectoryToFile() {
        }

        File before(File directory, String prefix, String suffix) throws IOException {
            return File.createTempFile(prefix, suffix, directory);
        }

        File after(File directory, String prefix, String suffix) throws IOException {
            return Files.createTempFile(directory.toPath(), prefix, suffix, new FileAttribute[0]).toFile();
        }
    }

    static final class FilesCreateTempFileToFile {
        FilesCreateTempFileToFile() {
        }

        File before(String prefix, String suffix) throws IOException {
            return (File)Refaster.anyOf((Object[])new File[]{File.createTempFile(prefix, suffix), File.createTempFile(prefix, suffix, null)});
        }

        File after(String prefix, String suffix) throws IOException {
            return Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
        }
    }

    static final class FilesReadString {
        FilesReadString() {
        }

        String before(Path path) throws IOException {
            return Files.readString(path, StandardCharsets.UTF_8);
        }

        String after(Path path) throws IOException {
            return Files.readString(path);
        }
    }

    static final class FilesReadStringWithCharset {
        FilesReadStringWithCharset() {
        }

        String before(Path path, Charset charset) throws IOException {
            return new String(Files.readAllBytes(path), charset);
        }

        String after(Path path, Charset charset) throws IOException {
            return Files.readString(path, charset);
        }
    }

    static final class PathInstance {
        PathInstance() {
        }

        Path before(Path path) {
            return path.toFile().toPath();
        }

        Path after(Path path) {
            return path;
        }
    }

    static final class PathOfString {
        PathOfString() {
        }

        Path before(String first, String more) {
            return Paths.get(first, more);
        }

        Path after(String first, String more) {
            return Path.of(first, more);
        }
    }

    static final class PathOfUri {
        PathOfUri() {
        }

        Path before(URI uri) {
            return Paths.get(uri);
        }

        Path after(URI uri) {
            return Path.of(uri);
        }
    }
}

