/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.refaster.Refaster;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.stream.Stream;

final class ImmutableEnumSetRules {
    private ImmutableEnumSetRules() {
    }

    static final class StreamToImmutableEnumSet<T extends Enum<T>> {
        StreamToImmutableEnumSet() {
        }

        ImmutableSet<T> before(Stream<T> stream) {
            return (ImmutableSet)stream.collect(ImmutableSet.toImmutableSet());
        }

        ImmutableSet<T> after(Stream<T> stream) {
            return (ImmutableSet)stream.collect(Sets.toImmutableEnumSet());
        }
    }

    static final class SetsImmutableEnumSetVarArgs<T extends Enum<T>> {
        SetsImmutableEnumSetVarArgs() {
        }

        ImmutableSet<T> before(T e1, T elements) {
            return ImmutableSet.copyOf(EnumSet.of(e1, (Enum[])Refaster.asVarargs(elements)));
        }

        ImmutableSet<T> after(T e1, T elements) {
            return Sets.immutableEnumSet(e1, (Enum[])((Enum[])Refaster.asVarargs(elements)));
        }
    }

    static final class SetsImmutableEnumSet6<T extends Enum<T>> {
        SetsImmutableEnumSet6() {
        }

        ImmutableSet<T> before(T e1, T e2, T e3, T e4, T e5, T e6) {
            return ImmutableSet.of(e1, e2, e3, e4, e5, e6, (Object[])new Enum[0]);
        }

        ImmutableSet<T> after(T e1, T e2, T e3, T e4, T e5, T e6) {
            return Sets.immutableEnumSet(e1, (Enum[])new Enum[]{e2, e3, e4, e5, e6});
        }
    }

    static final class SetsImmutableEnumSet5<T extends Enum<T>> {
        SetsImmutableEnumSet5() {
        }

        ImmutableSet<T> before(T e1, T e2, T e3, T e4, T e5) {
            return (ImmutableSet)Refaster.anyOf((Object[])new ImmutableSet[]{ImmutableSet.of(e1, e2, e3, e4, e5), ImmutableSet.copyOf(EnumSet.of(e1, e2, e3, e4, e5))});
        }

        ImmutableSet<T> after(T e1, T e2, T e3, T e4, T e5) {
            return Sets.immutableEnumSet(e1, (Enum[])new Enum[]{e2, e3, e4, e5});
        }
    }

    static final class SetsImmutableEnumSet4<T extends Enum<T>> {
        SetsImmutableEnumSet4() {
        }

        ImmutableSet<T> before(T e1, T e2, T e3, T e4) {
            return (ImmutableSet)Refaster.anyOf((Object[])new ImmutableSet[]{ImmutableSet.of(e1, e2, e3, e4), ImmutableSet.copyOf(EnumSet.of(e1, e2, e3, e4))});
        }

        ImmutableSet<T> after(T e1, T e2, T e3, T e4) {
            return Sets.immutableEnumSet(e1, (Enum[])new Enum[]{e2, e3, e4});
        }
    }

    static final class SetsImmutableEnumSet3<T extends Enum<T>> {
        SetsImmutableEnumSet3() {
        }

        ImmutableSet<T> before(T e1, T e2, T e3) {
            return (ImmutableSet)Refaster.anyOf((Object[])new ImmutableSet[]{ImmutableSet.of(e1, e2, e3), ImmutableSet.copyOf(EnumSet.of(e1, e2, e3))});
        }

        ImmutableSet<T> after(T e1, T e2, T e3) {
            return Sets.immutableEnumSet(e1, (Enum[])new Enum[]{e2, e3});
        }
    }

    static final class SetsImmutableEnumSet2<T extends Enum<T>> {
        SetsImmutableEnumSet2() {
        }

        ImmutableSet<T> before(T e1, T e2) {
            return (ImmutableSet)Refaster.anyOf((Object[])new ImmutableSet[]{ImmutableSet.of(e1, e2), ImmutableSet.copyOf(EnumSet.of(e1, e2))});
        }

        ImmutableSet<T> after(T e1, T e2) {
            return Sets.immutableEnumSet(e1, (Enum[])new Enum[]{e2});
        }
    }

    static final class SetsImmutableEnumSet1<T extends Enum<T>> {
        SetsImmutableEnumSet1() {
        }

        ImmutableSet<T> before(T e1) {
            return (ImmutableSet)Refaster.anyOf((Object[])new ImmutableSet[]{ImmutableSet.of(e1), ImmutableSet.copyOf(EnumSet.of(e1))});
        }

        ImmutableSet<T> after(T e1) {
            return Sets.immutableEnumSet(e1, (Enum[])new Enum[0]);
        }
    }

    static final class SetsImmutableEnumSetArraysAsList<T extends Enum<T>> {
        SetsImmutableEnumSetArraysAsList() {
        }

        ImmutableSet<T> before(T[] elements) {
            return ImmutableSet.copyOf((Object[])elements);
        }

        ImmutableSet<T> after(T[] elements) {
            return Sets.immutableEnumSet(Arrays.asList(elements));
        }
    }

    static final class SetsImmutableEnumSetIterable<T extends Enum<T>> {
        SetsImmutableEnumSetIterable() {
        }

        ImmutableSet<T> before(Iterable<T> elements) {
            return ImmutableSet.copyOf(elements);
        }

        ImmutableSet<T> before(Collection<T> elements) {
            return ImmutableSet.copyOf(elements);
        }

        ImmutableSet<T> after(Iterable<T> elements) {
            return Sets.immutableEnumSet(elements);
        }
    }
}

