/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class InputStreamRules {
    private InputStreamRules() {
    }

    static final class InputStreamSkipNBytes {
        InputStreamSkipNBytes() {
        }

        void before(InputStream in, long n) throws IOException {
            ByteStreams.skipFully((InputStream)in, (long)n);
        }

        void after(InputStream in, long n) throws IOException {
            in.skipNBytes(n);
        }
    }

    static final class InputStreamReadNBytes {
        InputStreamReadNBytes() {
        }

        byte[] before(InputStream in, int n) throws IOException {
            return ByteStreams.limit((InputStream)in, (long)n).readAllBytes();
        }

        byte[] after(InputStream in, int n) throws IOException {
            return in.readNBytes(n);
        }
    }

    static final class InputStreamReadAllBytes {
        InputStreamReadAllBytes() {
        }

        byte[] before(InputStream in) throws IOException {
            return ByteStreams.toByteArray((InputStream)in);
        }

        byte[] after(InputStream in) throws IOException {
            return in.readAllBytes();
        }
    }

    static final class InputStreamTransferTo {
        InputStreamTransferTo() {
        }

        long before(InputStream in, OutputStream out) throws IOException {
            return ByteStreams.copy((InputStream)in, (OutputStream)out);
        }

        long after(InputStream in, OutputStream out) throws IOException {
            return in.transferTo(out);
        }
    }
}

