/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.errorprone.refaster.Refaster;
import java.util.Optional;

final class JacksonRules {
    private JacksonRules() {
    }

    static final class JsonNodeOptionalString {
        JsonNodeOptionalString() {
        }

        Optional<JsonNode> before(JsonNode node, String fieldName) {
            return (Optional)Refaster.anyOf((Object[])new Optional[]{node.get(fieldName).asOptional(), node.path(fieldName).asOptional(), Optional.of(node.get(fieldName)), Optional.ofNullable(node.get(fieldName))});
        }

        Optional<JsonNode> after(JsonNode node, String fieldName) {
            return node.optional(fieldName);
        }
    }

    static final class JsonNodeOptionalInt {
        JsonNodeOptionalInt() {
        }

        Optional<JsonNode> before(JsonNode node, int index) {
            return (Optional)Refaster.anyOf((Object[])new Optional[]{node.get(index).asOptional(), node.path(index).asOptional(), Optional.of(node.get(index)), Optional.ofNullable(node.get(index))});
        }

        Optional<JsonNode> after(JsonNode node, int index) {
            return node.optional(index);
        }
    }
}

