/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.DoNotCall;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractDoubleArrayAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractFloatArrayAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.data.Offset;
import org.testng.Assert;

final class TestNGToAssertJRules {
    private TestNGToAssertJRules() {
    }

    static final class AssertThrowsWithType<T extends Throwable> {
        AssertThrowsWithType() {
        }

        void before(Assert.ThrowingRunnable runnable, Class<T> clazz) {
            Assert.assertThrows(clazz, (Assert.ThrowingRunnable)runnable);
        }

        void after(ThrowableAssert.ThrowingCallable runnable, Class<T> clazz) {
            Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)runnable).isInstanceOf(clazz);
        }
    }

    static final class AssertThrows {
        AssertThrows() {
        }

        void before(Assert.ThrowingRunnable runnable) {
            Assert.assertThrows((Assert.ThrowingRunnable)runnable);
        }

        void after(ThrowableAssert.ThrowingCallable runnable) {
            Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)runnable);
        }
    }

    static final class AssertUnequalDoublesWithDeltaWithMessage {
        AssertUnequalDoublesWithDeltaWithMessage() {
        }

        void before(double actual, String message, double expected, double delta) {
            Assert.assertNotEquals((double)actual, (double)expected, (double)delta, (String)message);
        }

        void after(double actual, String message, double expected, double delta) {
            ((AbstractDoubleAssert)Assertions.assertThat((double)actual).withFailMessage(message, new Object[0])).isNotCloseTo(expected, Offset.offset((Number)delta));
        }
    }

    static final class AssertUnequalDoublesWithDelta {
        AssertUnequalDoublesWithDelta() {
        }

        void before(double actual, double expected, double delta) {
            Assert.assertNotEquals((double)actual, (double)expected, (double)delta);
        }

        void after(double actual, double expected, double delta) {
            Assertions.assertThat((double)actual).isNotCloseTo(expected, Offset.offset((Number)delta));
        }
    }

    static final class AssertUnequalFloatsWithDeltaWithMessage {
        AssertUnequalFloatsWithDeltaWithMessage() {
        }

        void before(float actual, String message, float expected, float delta) {
            Assert.assertNotEquals((float)actual, (float)expected, (float)delta, (String)message);
        }

        void after(float actual, String message, float expected, float delta) {
            ((AbstractFloatAssert)Assertions.assertThat((float)actual).withFailMessage(message, new Object[0])).isNotCloseTo(expected, Offset.offset((Number)Float.valueOf(delta)));
        }
    }

    static final class AssertUnequalFloatsWithDelta {
        AssertUnequalFloatsWithDelta() {
        }

        void before(float actual, float expected, float delta) {
            Assert.assertNotEquals((float)actual, (float)expected, (float)delta);
        }

        void after(float actual, float expected, float delta) {
            Assertions.assertThat((float)actual).isNotCloseTo(expected, Offset.offset((Number)Float.valueOf(delta)));
        }
    }

    static final class AssertUnequalWithMessage {
        AssertUnequalWithMessage() {
        }

        void before(boolean actual, String message, boolean expected) {
            Assert.assertNotEquals((Object)actual, (Object)expected, (String)message);
        }

        void before(byte actual, String message, byte expected) {
            Assert.assertNotEquals((Object)actual, (Object)expected, (String)message);
        }

        void before(char actual, String message, char expected) {
            Assert.assertNotEquals((Object)Character.valueOf(actual), (Object)Character.valueOf(expected), (String)message);
        }

        void before(short actual, String message, short expected) {
            Assert.assertNotEquals((Object)actual, (Object)expected, (String)message);
        }

        void before(int actual, String message, int expected) {
            Assert.assertNotEquals((Object)actual, (Object)expected, (String)message);
        }

        void before(long actual, String message, long expected) {
            Assert.assertNotEquals((Object)actual, (Object)expected, (String)message);
        }

        void before(float actual, String message, float expected) {
            Assert.assertNotEquals((Object)Float.valueOf(actual), (Object)Float.valueOf(expected), (String)message);
        }

        void before(double actual, String message, double expected) {
            Assert.assertNotEquals((Object)actual, (Object)expected, (String)message);
        }

        void before(Object actual, String message, Object expected) {
            Assert.assertNotEquals((Object)actual, (Object)expected, (String)message);
        }

        void before(String actual, String message, String expected) {
            Assert.assertNotEquals((Object)actual, (Object)expected, (String)message);
        }

        void before(Set<?> actual, String message, Set<?> expected) {
            Assert.assertNotEquals(actual, expected, (String)message);
        }

        void before(Map<?, ?> actual, String message, Map<?, ?> expected) {
            Assert.assertNotEquals(actual, expected, (String)message);
        }

        void after(Object actual, String message, Object expected) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isNotEqualTo(expected);
        }
    }

    static final class AssertUnequal {
        AssertUnequal() {
        }

        void before(boolean actual, boolean expected) {
            Assert.assertNotEquals((Object)actual, (Object)expected);
        }

        void before(byte actual, byte expected) {
            Assert.assertNotEquals((Object)actual, (Object)expected);
        }

        void before(char actual, char expected) {
            Assert.assertNotEquals((Object)Character.valueOf(actual), (Object)Character.valueOf(expected));
        }

        void before(short actual, short expected) {
            Assert.assertNotEquals((Object)actual, (Object)expected);
        }

        void before(int actual, int expected) {
            Assert.assertNotEquals((Object)actual, (Object)expected);
        }

        void before(long actual, long expected) {
            Assert.assertNotEquals((Object)actual, (Object)expected);
        }

        void before(float actual, float expected) {
            Assert.assertNotEquals((Object)Float.valueOf(actual), (Object)Float.valueOf(expected));
        }

        void before(double actual, double expected) {
            Assert.assertNotEquals((Object)actual, (Object)expected);
        }

        void before(Object actual, Object expected) {
            Assert.assertNotEquals((Object)actual, (Object)expected);
        }

        void before(String actual, String expected) {
            Assert.assertNotEquals((Object)actual, (Object)expected);
        }

        void before(Set<?> actual, Set<?> expected) {
            Assert.assertNotEquals(actual, expected);
        }

        void before(Map<?, ?> actual, Map<?, ?> expected) {
            Assert.assertNotEquals(actual, expected);
        }

        void after(Object actual, Object expected) {
            Assertions.assertThat((Object)actual).isNotEqualTo(expected);
        }
    }

    static final class AssertEqualSetsWithMessage<S, T extends S> {
        AssertEqualSetsWithMessage() {
        }

        void before(Set<S> actual, String message, Set<T> expected) {
            Assert.assertEquals(actual, expected, (String)message);
        }

        void after(Set<S> actual, String message, Set<T> expected) {
            ((AbstractCollectionAssert)Assertions.assertThat(actual).withFailMessage(message, new Object[0])).hasSameElementsAs(expected);
        }
    }

    static final class AssertEqualSets<S, T extends S> {
        AssertEqualSets() {
        }

        void before(Set<S> actual, Set<T> expected) {
            Assert.assertEquals(actual, expected);
        }

        void after(Set<S> actual, Set<T> expected) {
            Assertions.assertThat(actual).hasSameElementsAs(expected);
        }
    }

    static final class AssertEqualIterableIterationOrderWithMessage<S, T extends S> {
        AssertEqualIterableIterationOrderWithMessage() {
        }

        void before(Iterable<S> actual, String message, Iterable<T> expected) {
            Assert.assertEquals(actual, expected, (String)message);
        }

        void before(Collection<S> actual, String message, Collection<T> expected) {
            Assert.assertEquals(actual, expected, (String)message);
        }

        void after(Iterable<S> actual, String message, Iterable<T> expected) {
            ((IterableAssert)Assertions.assertThat(actual).withFailMessage(message, new Object[0])).containsExactlyElementsOf(expected);
        }
    }

    static final class AssertEqualIterableIterationOrder<S, T extends S> {
        AssertEqualIterableIterationOrder() {
        }

        void before(Iterable<S> actual, Iterable<T> expected) {
            Assert.assertEquals(actual, expected);
        }

        void before(Collection<S> actual, Collection<T> expected) {
            Assert.assertEquals(actual, expected);
        }

        void after(Iterable<S> actual, Iterable<T> expected) {
            Assertions.assertThat(actual).containsExactlyElementsOf(expected);
        }
    }

    static final class AssertEqualIteratorIterationOrderWithMessage<S, T extends S> {
        AssertEqualIteratorIterationOrderWithMessage() {
        }

        void before(Iterator<S> actual, String message, Iterator<T> expected) {
            Assert.assertEquals(actual, expected, (String)message);
        }

        void after(Iterator<S> actual, String message, Iterator<T> expected) {
            ((IterableAssert)Assertions.assertThat(actual).toIterable().withFailMessage(message, new Object[0])).containsExactlyElementsOf((Iterable)ImmutableList.copyOf(expected));
        }
    }

    static final class AssertEqualIteratorIterationOrder<S, T extends S> {
        AssertEqualIteratorIterationOrder() {
        }

        void before(Iterator<S> actual, Iterator<T> expected) {
            Assert.assertEquals(actual, expected);
        }

        void after(Iterator<S> actual, Iterator<T> expected) {
            Assertions.assertThat(actual).toIterable().containsExactlyElementsOf((Iterable)ImmutableList.copyOf(expected));
        }
    }

    static final class AssertEqualArraysIrrespectiveOfOrderWithMessage {
        AssertEqualArraysIrrespectiveOfOrderWithMessage() {
        }

        void before(Object[] actual, String message, Object[] expected) {
            Assert.assertEqualsNoOrder((Object[])actual, (Object[])expected, (String)message);
        }

        void after(Object[] actual, String message, Object[] expected) {
            ((ObjectArrayAssert)Assertions.assertThat((Object[])actual).withFailMessage(message, new Object[0])).containsExactlyInAnyOrder(expected);
        }
    }

    static final class AssertEqualArraysIrrespectiveOfOrder {
        AssertEqualArraysIrrespectiveOfOrder() {
        }

        void before(Object[] actual, Object[] expected) {
            Assert.assertEqualsNoOrder((Object[])actual, (Object[])expected);
        }

        void after(Object[] actual, Object[] expected) {
            Assertions.assertThat((Object[])actual).containsExactlyInAnyOrder(expected);
        }
    }

    static final class AssertEqualDoubleArraysWithDeltaWithMessage {
        AssertEqualDoubleArraysWithDeltaWithMessage() {
        }

        void before(double[] actual, String message, double[] expected, double delta) {
            Assert.assertEquals((double[])actual, (double[])expected, (double)delta, (String)message);
        }

        void after(double[] actual, String message, double[] expected, double delta) {
            ((AbstractDoubleArrayAssert)Assertions.assertThat((double[])actual).withFailMessage(message, new Object[0])).containsExactly(expected, Offset.offset((Number)delta));
        }
    }

    static final class AssertEqualDoubleArraysWithDelta {
        AssertEqualDoubleArraysWithDelta() {
        }

        void before(double[] actual, double[] expected, double delta) {
            Assert.assertEquals((double[])actual, (double[])expected, (double)delta);
        }

        void after(double[] actual, double[] expected, double delta) {
            Assertions.assertThat((double[])actual).containsExactly(expected, Offset.offset((Number)delta));
        }
    }

    static final class AssertEqualFloatArraysWithDeltaWithMessage {
        AssertEqualFloatArraysWithDeltaWithMessage() {
        }

        void before(float[] actual, String message, float[] expected, float delta) {
            Assert.assertEquals((float[])actual, (float[])expected, (float)delta, (String)message);
        }

        void after(float[] actual, String message, float[] expected, float delta) {
            ((AbstractFloatArrayAssert)Assertions.assertThat((float[])actual).withFailMessage(message, new Object[0])).containsExactly(expected, Offset.offset((Number)Float.valueOf(delta)));
        }
    }

    static final class AssertEqualFloatArraysWithDelta {
        AssertEqualFloatArraysWithDelta() {
        }

        void before(float[] actual, float[] expected, float delta) {
            Assert.assertEquals((float[])actual, (float[])expected, (float)delta);
        }

        void after(float[] actual, float[] expected, float delta) {
            Assertions.assertThat((float[])actual).containsExactly(expected, Offset.offset((Number)Float.valueOf(delta)));
        }
    }

    static final class AssertEqualArrayIterationOrderWithMessage {
        AssertEqualArrayIterationOrderWithMessage() {
        }

        void before(boolean[] actual, String message, boolean[] expected) {
            Assert.assertEquals((boolean[])actual, (boolean[])expected, (String)message);
        }

        void before(byte[] actual, String message, byte[] expected) {
            Assert.assertEquals((byte[])actual, (byte[])expected, (String)message);
        }

        void before(char[] actual, String message, char[] expected) {
            Assert.assertEquals((char[])actual, (char[])expected, (String)message);
        }

        void before(short[] actual, String message, short[] expected) {
            Assert.assertEquals((short[])actual, (short[])expected, (String)message);
        }

        void before(int[] actual, String message, int[] expected) {
            Assert.assertEquals((int[])actual, (int[])expected, (String)message);
        }

        void before(long[] actual, String message, long[] expected) {
            Assert.assertEquals((long[])actual, (long[])expected, (String)message);
        }

        void before(float[] actual, String message, float[] expected) {
            Assert.assertEquals((float[])actual, (float[])expected, (String)message);
        }

        void before(double[] actual, String message, double[] expected) {
            Assert.assertEquals((double[])actual, (double[])expected, (String)message);
        }

        void before(Object[] actual, String message, Object[] expected) {
            Assert.assertEquals((Object[])actual, (Object[])expected, (String)message);
        }

        void after(Object[] actual, String message, Object[] expected) {
            ((ObjectArrayAssert)Assertions.assertThat((Object[])actual).withFailMessage(message, new Object[0])).containsExactly(expected);
        }
    }

    static final class AssertEqualArrayIterationOrder {
        AssertEqualArrayIterationOrder() {
        }

        void before(boolean[] actual, boolean[] expected) {
            Assert.assertEquals((boolean[])actual, (boolean[])expected);
        }

        void before(byte[] actual, byte[] expected) {
            Assert.assertEquals((byte[])actual, (byte[])expected);
        }

        void before(char[] actual, char[] expected) {
            Assert.assertEquals((char[])actual, (char[])expected);
        }

        void before(short[] actual, short[] expected) {
            Assert.assertEquals((short[])actual, (short[])expected);
        }

        void before(int[] actual, int[] expected) {
            Assert.assertEquals((int[])actual, (int[])expected);
        }

        void before(long[] actual, long[] expected) {
            Assert.assertEquals((long[])actual, (long[])expected);
        }

        void before(float[] actual, float[] expected) {
            Assert.assertEquals((float[])actual, (float[])expected);
        }

        void before(double[] actual, double[] expected) {
            Assert.assertEquals((double[])actual, (double[])expected);
        }

        void before(Object[] actual, Object[] expected) {
            Assert.assertEquals((Object[])actual, (Object[])expected);
        }

        void after(Object[] actual, Object[] expected) {
            Assertions.assertThat((Object[])actual).containsExactly(expected);
        }
    }

    static final class AssertEqualDoublesWithDeltaWithMessage {
        AssertEqualDoublesWithDeltaWithMessage() {
        }

        void before(double actual, String message, double expected, double delta) {
            Assert.assertEquals((double)actual, (double)expected, (double)delta, (String)message);
        }

        void after(double actual, String message, double expected, double delta) {
            ((AbstractDoubleAssert)Assertions.assertThat((double)actual).withFailMessage(message, new Object[0])).isCloseTo(expected, Offset.offset((Number)delta));
        }
    }

    static final class AssertEqualDoublesWithDelta {
        AssertEqualDoublesWithDelta() {
        }

        void before(double actual, double expected, double delta) {
            Assert.assertEquals((double)actual, (double)expected, (double)delta);
        }

        void after(double actual, double expected, double delta) {
            Assertions.assertThat((double)actual).isCloseTo(expected, Offset.offset((Number)delta));
        }
    }

    static final class AssertEqualFloatsWithDeltaWithMessage {
        AssertEqualFloatsWithDeltaWithMessage() {
        }

        void before(float actual, String message, float expected, float delta) {
            Assert.assertEquals((float)actual, (float)expected, (float)delta, (String)message);
        }

        void after(float actual, String message, float expected, float delta) {
            ((AbstractFloatAssert)Assertions.assertThat((float)actual).withFailMessage(message, new Object[0])).isCloseTo(expected, Offset.offset((Number)Float.valueOf(delta)));
        }
    }

    static final class AssertEqualFloatsWithDelta {
        AssertEqualFloatsWithDelta() {
        }

        void before(float actual, float expected, float delta) {
            Assert.assertEquals((float)actual, (float)expected, (float)delta);
        }

        void after(Float actual, float expected, float delta) {
            Assertions.assertThat((Float)actual).isCloseTo(expected, Offset.offset((Number)Float.valueOf(delta)));
        }
    }

    static final class AssertEqualWithMessage {
        AssertEqualWithMessage() {
        }

        void before(boolean actual, String message, boolean expected) {
            Assert.assertEquals((boolean)actual, (boolean)expected, (String)message);
        }

        void before(boolean actual, String message, Boolean expected) {
            Assert.assertEquals((boolean)actual, (Boolean)expected, (String)message);
        }

        void before(Boolean actual, String message, boolean expected) {
            Assert.assertEquals((Boolean)actual, (boolean)expected, (String)message);
        }

        void before(Boolean actual, String message, Boolean expected) {
            Assert.assertEquals((Boolean)actual, (Boolean)expected, (String)message);
        }

        void before(byte actual, String message, byte expected) {
            Assert.assertEquals((byte)actual, (byte)expected, (String)message);
        }

        void before(byte actual, String message, Byte expected) {
            Assert.assertEquals((byte)actual, (Byte)expected, (String)message);
        }

        void before(Byte actual, String message, byte expected) {
            Assert.assertEquals((Byte)actual, (byte)expected, (String)message);
        }

        void before(Byte actual, String message, Byte expected) {
            Assert.assertEquals((Byte)actual, (Byte)expected, (String)message);
        }

        void before(char actual, String message, char expected) {
            Assert.assertEquals((char)actual, (char)expected, (String)message);
        }

        void before(char actual, String message, Character expected) {
            Assert.assertEquals((char)actual, (Character)expected, (String)message);
        }

        void before(Character actual, String message, char expected) {
            Assert.assertEquals((Character)actual, (char)expected, (String)message);
        }

        void before(Character actual, String message, Character expected) {
            Assert.assertEquals((Character)actual, (Character)expected, (String)message);
        }

        void before(short actual, String message, short expected) {
            Assert.assertEquals((short)actual, (short)expected, (String)message);
        }

        void before(short actual, String message, Short expected) {
            Assert.assertEquals((short)actual, (Short)expected, (String)message);
        }

        void before(Short actual, String message, short expected) {
            Assert.assertEquals((Short)actual, (short)expected, (String)message);
        }

        void before(Short actual, String message, Short expected) {
            Assert.assertEquals((Short)actual, (Short)expected, (String)message);
        }

        void before(int actual, String message, int expected) {
            Assert.assertEquals((int)actual, (int)expected, (String)message);
        }

        void before(int actual, String message, Integer expected) {
            Assert.assertEquals((int)actual, (Integer)expected, (String)message);
        }

        void before(Integer actual, String message, int expected) {
            Assert.assertEquals((Integer)actual, (int)expected, (String)message);
        }

        void before(Integer actual, String message, Integer expected) {
            Assert.assertEquals((Integer)actual, (Integer)expected, (String)message);
        }

        void before(long actual, String message, long expected) {
            Assert.assertEquals((long)actual, (long)expected, (String)message);
        }

        void before(long actual, String message, Long expected) {
            Assert.assertEquals((long)actual, (Long)expected, (String)message);
        }

        void before(Long actual, String message, long expected) {
            Assert.assertEquals((Long)actual, (long)expected, (String)message);
        }

        void before(Long actual, String message, Long expected) {
            Assert.assertEquals((Long)actual, (Long)expected, (String)message);
        }

        void before(float actual, String message, float expected) {
            Assert.assertEquals((float)actual, (float)expected, (String)message);
        }

        void before(float actual, String message, Float expected) {
            Assert.assertEquals((float)actual, (Float)expected, (String)message);
        }

        void before(Float actual, String message, float expected) {
            Assert.assertEquals((Float)actual, (float)expected, (String)message);
        }

        void before(Float actual, String message, Float expected) {
            Assert.assertEquals((Float)actual, (Float)expected, (String)message);
        }

        void before(double actual, String message, double expected) {
            Assert.assertEquals((double)actual, (double)expected, (String)message);
        }

        void before(double actual, String message, Double expected) {
            Assert.assertEquals((double)actual, (Double)expected, (String)message);
        }

        void before(Double actual, String message, double expected) {
            Assert.assertEquals((Double)actual, (double)expected, (String)message);
        }

        void before(Double actual, String message, Double expected) {
            Assert.assertEquals((Double)actual, (Double)expected, (String)message);
        }

        void before(Object actual, String message, Object expected) {
            Assert.assertEquals((Object)actual, (Object)expected, (String)message);
        }

        void before(String actual, String message, String expected) {
            Assert.assertEquals((String)actual, (String)expected, (String)message);
        }

        void before(Map<?, ?> actual, String message, Map<?, ?> expected) {
            Assert.assertEquals(actual, expected, (String)message);
        }

        void after(Object actual, String message, Object expected) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isEqualTo(expected);
        }
    }

    static final class AssertEqual {
        AssertEqual() {
        }

        void before(boolean actual, boolean expected) {
            Assert.assertEquals((boolean)actual, (boolean)expected);
        }

        void before(boolean actual, Boolean expected) {
            Assert.assertEquals((boolean)actual, (Boolean)expected);
        }

        void before(Boolean actual, boolean expected) {
            Assert.assertEquals((Boolean)actual, (boolean)expected);
        }

        void before(Boolean actual, Boolean expected) {
            Assert.assertEquals((Boolean)actual, (Boolean)expected);
        }

        void before(byte actual, byte expected) {
            Assert.assertEquals((byte)actual, (byte)expected);
        }

        void before(byte actual, Byte expected) {
            Assert.assertEquals((byte)actual, (Byte)expected);
        }

        void before(Byte actual, byte expected) {
            Assert.assertEquals((Byte)actual, (byte)expected);
        }

        void before(Byte actual, Byte expected) {
            Assert.assertEquals((Byte)actual, (Byte)expected);
        }

        void before(char actual, char expected) {
            Assert.assertEquals((char)actual, (char)expected);
        }

        void before(char actual, Character expected) {
            Assert.assertEquals((char)actual, (Character)expected);
        }

        void before(Character actual, char expected) {
            Assert.assertEquals((Character)actual, (char)expected);
        }

        void before(Character actual, Character expected) {
            Assert.assertEquals((Character)actual, (Character)expected);
        }

        void before(short actual, short expected) {
            Assert.assertEquals((short)actual, (short)expected);
        }

        void before(short actual, Short expected) {
            Assert.assertEquals((short)actual, (Short)expected);
        }

        void before(Short actual, short expected) {
            Assert.assertEquals((Short)actual, (short)expected);
        }

        void before(Short actual, Short expected) {
            Assert.assertEquals((Short)actual, (Short)expected);
        }

        void before(int actual, int expected) {
            Assert.assertEquals((int)actual, (int)expected);
        }

        void before(int actual, Integer expected) {
            Assert.assertEquals((int)actual, (Integer)expected);
        }

        void before(Integer actual, int expected) {
            Assert.assertEquals((Integer)actual, (int)expected);
        }

        void before(Integer actual, Integer expected) {
            Assert.assertEquals((Integer)actual, (Integer)expected);
        }

        void before(long actual, long expected) {
            Assert.assertEquals((long)actual, (long)expected);
        }

        void before(long actual, Long expected) {
            Assert.assertEquals((long)actual, (Long)expected);
        }

        void before(Long actual, long expected) {
            Assert.assertEquals((Long)actual, (long)expected);
        }

        void before(Long actual, Long expected) {
            Assert.assertEquals((Long)actual, (Long)expected);
        }

        void before(float actual, float expected) {
            Assert.assertEquals((float)actual, (float)expected);
        }

        void before(float actual, Float expected) {
            Assert.assertEquals((float)actual, (Float)expected);
        }

        void before(Float actual, float expected) {
            Assert.assertEquals((Float)actual, (float)expected);
        }

        void before(Float actual, Float expected) {
            Assert.assertEquals((Float)actual, (Float)expected);
        }

        void before(double actual, double expected) {
            Assert.assertEquals((double)actual, (double)expected);
        }

        void before(double actual, Double expected) {
            Assert.assertEquals((double)actual, (Double)expected);
        }

        void before(Double actual, double expected) {
            Assert.assertEquals((Double)actual, (double)expected);
        }

        void before(Double actual, Double expected) {
            Assert.assertEquals((Double)actual, (Double)expected);
        }

        void before(Object actual, Object expected) {
            Assert.assertEquals((Object)actual, (Object)expected);
        }

        void before(String actual, String expected) {
            Assert.assertEquals((String)actual, (String)expected);
        }

        void before(Map<?, ?> actual, Map<?, ?> expected) {
            Assert.assertEquals(actual, expected);
        }

        void after(Object actual, Object expected) {
            Assertions.assertThat((Object)actual).isEqualTo(expected);
        }
    }

    static final class AssertNotSameWithMessage {
        AssertNotSameWithMessage() {
        }

        void before(Object actual, String message, Object expected) {
            Assert.assertNotSame((Object)actual, (Object)expected, (String)message);
        }

        void after(Object actual, String message, Object expected) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isNotSameAs(expected);
        }
    }

    static final class AssertNotSame {
        AssertNotSame() {
        }

        void before(Object actual, Object expected) {
            Assert.assertNotSame((Object)actual, (Object)expected);
        }

        void after(Object actual, Object expected) {
            Assertions.assertThat((Object)actual).isNotSameAs(expected);
        }
    }

    static final class AssertSameWithMessage {
        AssertSameWithMessage() {
        }

        void before(Object actual, String message, Object expected) {
            Assert.assertSame((Object)actual, (Object)expected, (String)message);
        }

        void after(Object actual, String message, Object expected) {
            ((ObjectAssert)Assertions.assertThat((Object)actual).withFailMessage(message, new Object[0])).isSameAs(expected);
        }
    }

    static final class AssertSame {
        AssertSame() {
        }

        void before(Object actual, Object expected) {
            Assert.assertSame((Object)actual, (Object)expected);
        }

        void after(Object actual, Object expected) {
            Assertions.assertThat((Object)actual).isSameAs(expected);
        }
    }

    static final class AssertNotNullWithMessage {
        AssertNotNullWithMessage() {
        }

        void before(Object object, String message) {
            Assert.assertNotNull((Object)object, (String)message);
        }

        void after(Object object, String message) {
            ((ObjectAssert)Assertions.assertThat((Object)object).withFailMessage(message, new Object[0])).isNotNull();
        }
    }

    static final class AssertNotNull {
        AssertNotNull() {
        }

        void before(Object object) {
            Assert.assertNotNull((Object)object);
        }

        void after(Object object) {
            Assertions.assertThat((Object)object).isNotNull();
        }
    }

    static final class AssertNullWithMessage {
        AssertNullWithMessage() {
        }

        void before(Object object, String message) {
            Assert.assertNull((Object)object, (String)message);
        }

        void after(Object object, String message) {
            ((ObjectAssert)Assertions.assertThat((Object)object).withFailMessage(message, new Object[0])).isNull();
        }
    }

    static final class AssertNull {
        AssertNull() {
        }

        void before(Object object) {
            Assert.assertNull((Object)object);
        }

        void after(Object object) {
            Assertions.assertThat((Object)object).isNull();
        }
    }

    static final class AssertFalseWithMessage {
        AssertFalseWithMessage() {
        }

        void before(boolean condition, String message) {
            Assert.assertFalse((boolean)condition, (String)message);
        }

        void after(boolean condition, String message) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)condition).withFailMessage(message, new Object[0])).isFalse();
        }
    }

    static final class AssertFalse {
        AssertFalse() {
        }

        void before(boolean condition) {
            Assert.assertFalse((boolean)condition);
        }

        void after(boolean condition) {
            Assertions.assertThat((boolean)condition).isFalse();
        }
    }

    static final class AssertTrueWithMessage {
        AssertTrueWithMessage() {
        }

        void before(boolean condition, String message) {
            Assert.assertTrue((boolean)condition, (String)message);
        }

        void after(boolean condition, String message) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)condition).withFailMessage(message, new Object[0])).isTrue();
        }
    }

    static final class AssertTrue {
        AssertTrue() {
        }

        void before(boolean condition) {
            Assert.assertTrue((boolean)condition);
        }

        void after(boolean condition) {
            Assertions.assertThat((boolean)condition).isTrue();
        }
    }

    static final class FailWithMessageAndThrowable {
        FailWithMessageAndThrowable() {
        }

        void before(String message, Throwable throwable) {
            Assert.fail((String)message, (Throwable)throwable);
        }

        void after(String message, Throwable throwable) {
            Assertions.fail((String)message, (Throwable)throwable);
        }
    }

    static final class FailWithMessage {
        FailWithMessage() {
        }

        void before(String message) {
            Assert.fail((String)message);
        }

        void after(String message) {
            Assertions.fail((String)message);
        }
    }

    static final class Fail {
        Fail() {
        }

        void before() {
            Assert.fail();
        }

        @DoNotCall
        void after() {
            Assertions.fail();
        }
    }
}

