/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class ComparatorRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`ComparatorRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `Comparator`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ComparatorRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new ReverseOrderRecipe(), new ThenComparingRecipe(), new ThenComparingReversedRecipe(), new ThenComparingCustomRecipe(), new ThenComparingCustomReversedRecipe(), new ThenComparingDoubleRecipe(), new ThenComparingIntRecipe(), new ThenComparingLongRecipe(), new CompareToRecipe(), new CollectionsSortRecipe(), new CollectionsMinRecipe(), new MinOfArrayRecipe(), new CollectionsMinWithComparatorRecipe(), new CollectionsMaxRecipe(), new MaxOfArrayRecipe(), new CollectionsMaxWithComparatorRecipe(), new ComparatorsMinRecipe(), new ComparatorsMaxRecipe(), new MinByNaturalOrderRecipe(), new MaxByNaturalOrderRecipe(), new IsLessThanRecipe(), new IsLessThanOrEqualToRecipe()});
    }

    @NullMarked
    public static class ReverseOrderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.ReverseOrder`";
        }

        public String getDescription() {
            return "Prefer `Comparator#reverseOrder()` over more complicated constructs.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.util.Collections.reverseOrder()").bindType("java.util.Comparator<T>").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Collections");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Comparator.reverseOrder()").bindType("java.util.Comparator<T>").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Collections.<T>reverseOrder(java.util.Comparator.naturalOrder())").bindType("java.util.Comparator<T>").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Collections");
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Comparator.reverseOrder()").bindType("java.util.Comparator<T>").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"java.util.Comparator.<T>naturalOrder().reversed()").bindType("java.util.Comparator<T>").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Comparator.reverseOrder()").bindType("java.util.Comparator<T>").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Comparator naturalOrder(..)", true), new UsesMethod("java.util.Comparator reversed(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collections", Boolean.valueOf(true)), new UsesMethod("java.util.Collections reverseOrder(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collections", Boolean.valueOf(true)), new UsesMethod("java.util.Collections reverseOrder(..)", true), new UsesMethod("java.util.Comparator naturalOrder(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ThenComparingRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.ThenComparing`";
        }

        public String getDescription() {
            return "Don't explicitly create `Comparator`s unnecessarily.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{cmp:any(java.util.Comparator<S>)}.thenComparing(java.util.Comparator.comparing(#{function:any(java.util.function.Function<? super S, ? extends T>)}))").bindType("java.util.Comparator<S>").genericTypes(new String[]{"S", "T extends java.lang.Comparable<? super T>"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.comparing");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{cmp:any(java.util.Comparator<S>)}.thenComparing(#{function:any(java.util.function.Function<? super S, ? extends T>)})").bindType("java.util.Comparator<S>").genericTypes(new String[]{"S", "T extends java.lang.Comparable<? super T>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("java.util.Comparator comparing(..)", true), new UsesMethod("java.util.Comparator thenComparing(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ThenComparingReversedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.ThenComparingReversed`";
        }

        public String getDescription() {
            return "Don't explicitly create `Comparator`s unnecessarily.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{cmp:any(java.util.Comparator<S>)}.thenComparing(java.util.Comparator.comparing(#{function:any(java.util.function.Function<? super S, ? extends T>)}).reversed())").bindType("java.util.Comparator<S>").genericTypes(new String[]{"S", "T extends java.lang.Comparable<? super T>"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.comparing");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{cmp:any(java.util.Comparator<S>)}.thenComparing(#{function:any(java.util.function.Function<? super S, ? extends T>)}, java.util.Comparator.reverseOrder())").bindType("java.util.Comparator<S>").genericTypes(new String[]{"S", "T extends java.lang.Comparable<? super T>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("java.util.Comparator comparing(..)", true), new UsesMethod("java.util.Comparator reversed(..)", true), new UsesMethod("java.util.Comparator thenComparing(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ThenComparingCustomRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.ThenComparingCustom`";
        }

        public String getDescription() {
            return "Don't explicitly create `Comparator`s unnecessarily.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{cmp:any(java.util.Comparator<S>)}.thenComparing(java.util.Comparator.comparing(#{function:any(java.util.function.Function<? super S, ? extends T>)}, #{cmp2:any(java.util.Comparator<? super T>)}))").bindType("java.util.Comparator<S>").genericTypes(new String[]{"S", "T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.comparing");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{cmp:any(java.util.Comparator<S>)}.thenComparing(#{function:any(java.util.function.Function<? super S, ? extends T>)}, #{cmp2:any(java.util.Comparator<? super T>)})").bindType("java.util.Comparator<S>").genericTypes(new String[]{"S", "T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("java.util.Comparator comparing(..)", true), new UsesMethod("java.util.Comparator thenComparing(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ThenComparingCustomReversedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.ThenComparingCustomReversed`";
        }

        public String getDescription() {
            return "Don't explicitly create `Comparator`s unnecessarily.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{cmp:any(java.util.Comparator<S>)}.thenComparing(java.util.Comparator.comparing(#{function:any(java.util.function.Function<? super S, ? extends T>)}, #{cmp2:any(java.util.Comparator<? super T>)}).reversed())").bindType("java.util.Comparator<S>").genericTypes(new String[]{"S", "T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.comparing");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{cmp:any(java.util.Comparator<S>)}.thenComparing(#{function:any(java.util.function.Function<? super S, ? extends T>)}, #{cmp2:any(java.util.Comparator<? super T>)}.reversed())").bindType("java.util.Comparator<S>").genericTypes(new String[]{"S", "T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.Function", Boolean.valueOf(true)), new UsesMethod("java.util.Comparator comparing(..)", true), new UsesMethod("java.util.Comparator reversed(..)", true), new UsesMethod("java.util.Comparator thenComparing(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ThenComparingDoubleRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.ThenComparingDouble`";
        }

        public String getDescription() {
            return "Don't explicitly create `Comparator`s unnecessarily.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{cmp:any(java.util.Comparator<T>)}.thenComparing(java.util.Comparator.comparingDouble(#{function:any(java.util.function.ToDoubleFunction<? super T>)}))").bindType("java.util.Comparator<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.comparingDouble");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{cmp:any(java.util.Comparator<T>)}.thenComparingDouble(#{function:any(java.util.function.ToDoubleFunction<? super T>)})").bindType("java.util.Comparator<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.ToDoubleFunction", Boolean.valueOf(true)), new UsesMethod("java.util.Comparator comparingDouble(..)", true), new UsesMethod("java.util.Comparator thenComparing(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ThenComparingIntRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.ThenComparingInt`";
        }

        public String getDescription() {
            return "Don't explicitly create `Comparator`s unnecessarily.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{cmp:any(java.util.Comparator<T>)}.thenComparing(java.util.Comparator.comparingInt(#{function:any(java.util.function.ToIntFunction<? super T>)}))").bindType("java.util.Comparator<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.comparingInt");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{cmp:any(java.util.Comparator<T>)}.thenComparingInt(#{function:any(java.util.function.ToIntFunction<? super T>)})").bindType("java.util.Comparator<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.ToIntFunction", Boolean.valueOf(true)), new UsesMethod("java.util.Comparator comparingInt(..)", true), new UsesMethod("java.util.Comparator thenComparing(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ThenComparingLongRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.ThenComparingLong`";
        }

        public String getDescription() {
            return "Don't explicitly create `Comparator`s unnecessarily.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{cmp:any(java.util.Comparator<T>)}.thenComparing(java.util.Comparator.comparingLong(#{function:any(java.util.function.ToLongFunction<? super T>)}))").bindType("java.util.Comparator<T>").genericTypes(new String[]{"T"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.comparingLong");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{cmp:any(java.util.Comparator<T>)}.thenComparingLong(#{function:any(java.util.function.ToLongFunction<? super T>)})").bindType("java.util.Comparator<T>").genericTypes(new String[]{"T"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesType("java.util.function.ToLongFunction", Boolean.valueOf(true)), new UsesMethod("java.util.Comparator comparingLong(..)", true), new UsesMethod("java.util.Comparator thenComparing(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CompareToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.CompareTo`";
        }

        public String getDescription() {
            return "Prefer `Comparable#compareTo(Object)`} over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.util.Comparator.<T>naturalOrder().compare(#{value1:any(T)}, #{value2:any(T)})").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{value1:any(T)}.compareTo(#{value2:any(T)})").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Comparator.<T>reverseOrder().compare(#{value2:any(T)}, #{value1:any(T)})").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{value1:any(T)}.compareTo(#{value2:any(T)})").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(1), matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesMethod("java.util.Comparator compare(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Comparator naturalOrder(..)", true), new UsesMethod("java.util.Comparator reverseOrder(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CollectionsSortRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.CollectionsSort`";
        }

        public String getDescription() {
            return "Prefer `Collections#sort(List)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.Collections.sort(#{collection:any(java.util.List<T>)}, java.util.Comparator.naturalOrder());").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Collections.sort(#{collection:any(java.util.List<T>)});").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collections", Boolean.valueOf(true)), new UsesType("java.util.List", Boolean.valueOf(true)), new UsesMethod("java.util.Collections sort(..)", true), new UsesMethod("java.util.Comparator naturalOrder(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CollectionsMinRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.CollectionsMin`";
        }

        public String getDescription() {
            return "Prefer `Collections#min(Collection)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.util.Collections.min(#{collection:any(java.util.Collection<T>)}, java.util.Comparator.naturalOrder())").bindType("T").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Collections.min(#{collection:any(java.util.Collection<T>)})").bindType("T").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Collections.max(#{collection:any(java.util.Collection<T>)}, java.util.Comparator.reverseOrder())").bindType("T").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.reverseOrder");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Collections.min(#{collection:any(java.util.Collection<T>)})").bindType("T").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesType("java.util.Collections", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Collections max(..)", true), new UsesMethod("java.util.Comparator reverseOrder(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Collections min(..)", true), new UsesMethod("java.util.Comparator naturalOrder(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MinOfArrayRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.MinOfArray`";
        }

        public String getDescription() {
            return "Avoid unnecessary creation of a `Stream` to determine the minimum of a known collection of values.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.Arrays.stream(#{array:any(T[])}).min(#{cmp:any(java.util.Comparator<S>)}).orElseThrow()").bindType("T").genericTypes(new String[]{"S", "T extends S"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Collections.min(java.util.Arrays.asList(#{array:any(T[])}), #{cmp:any(java.util.Comparator<S>)})").bindType("T").genericTypes(new String[]{"S", "T extends S"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Arrays", Boolean.valueOf(true)), new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesMethod("java.util.Arrays stream(..)", true), new UsesMethod("java.util.Optional orElseThrow(..)", true), new UsesMethod("java.util.stream.Stream min(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CollectionsMinWithComparatorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.CollectionsMinWithComparator`";
        }

        public String getDescription() {
            return "Avoid unnecessary creation of a `Stream` to determine the minimum of a known collection of values.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.stream().min(#{cmp:any(java.util.Comparator<S>)}).orElseThrow()").bindType("T").genericTypes(new String[]{"S", "T extends S"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Collections.min(#{collection:any(java.util.Collection<T>)}, #{cmp:any(java.util.Comparator<S>)})").bindType("T").genericTypes(new String[]{"S", "T extends S"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.Optional orElseThrow(..)", true), new UsesMethod("java.util.stream.Stream min(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CollectionsMaxRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.CollectionsMax`";
        }

        public String getDescription() {
            return "Prefer `Collections#max(Collection)` over more verbose alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"java.util.Collections.max(#{collection:any(java.util.Collection<T>)}, java.util.Comparator.naturalOrder())").bindType("T").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Collections.max(#{collection:any(java.util.Collection<T>)})").bindType("T").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.Collections.min(#{collection:any(java.util.Collection<T>)}, java.util.Comparator.reverseOrder())").bindType("T").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.reverseOrder");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Collections.max(#{collection:any(java.util.Collection<T>)})").bindType("T").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesType("java.util.Collections", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Collections max(..)", true), new UsesMethod("java.util.Comparator naturalOrder(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.Collections min(..)", true), new UsesMethod("java.util.Comparator reverseOrder(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MaxOfArrayRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.MaxOfArray`";
        }

        public String getDescription() {
            return "Avoid unnecessary creation of a `Stream` to determine the maximum of a known collection of values.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.Arrays.stream(#{array:any(T[])}).max(#{cmp:any(java.util.Comparator<S>)}).orElseThrow()").bindType("T").genericTypes(new String[]{"S", "T extends S"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Collections.max(java.util.Arrays.asList(#{array:any(T[])}), #{cmp:any(java.util.Comparator<S>)})").bindType("T").genericTypes(new String[]{"S", "T extends S"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Arrays", Boolean.valueOf(true)), new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesMethod("java.util.Arrays stream(..)", true), new UsesMethod("java.util.Optional orElseThrow(..)", true), new UsesMethod("java.util.stream.Stream max(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CollectionsMaxWithComparatorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.CollectionsMaxWithComparator`";
        }

        public String getDescription() {
            return "Avoid unnecessary creation of a `Stream` to determine the maximum of a known collection of values.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{collection:any(java.util.Collection<T>)}.stream().max(#{cmp:any(java.util.Comparator<S>)}).orElseThrow()").bindType("T").genericTypes(new String[]{"S", "T extends S"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Collections.max(#{collection:any(java.util.Collection<T>)}, #{cmp:any(java.util.Comparator<S>)})").bindType("T").genericTypes(new String[]{"S", "T extends S"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collection", Boolean.valueOf(true)), new UsesType("java.util.Comparator", Boolean.valueOf(true)), new UsesMethod("java.util.Collection stream(..)", true), new UsesMethod("java.util.Optional orElseThrow(..)", true), new UsesMethod("java.util.stream.Stream max(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ComparatorsMinRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.ComparatorsMin`";
        }

        public String getDescription() {
            return "Prefer a method reference to `Comparators#min(Comparable, Comparable)` over calling `BinaryOperator#minBy(Comparator)` with `Comparator#naturalOrder()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.function.BinaryOperator.minBy(java.util.Comparator.naturalOrder())").bindType("java.util.function.BinaryOperator<T>").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Comparators::min").bindType("java.util.function.BinaryOperator<T>").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.BinaryOperator", Boolean.valueOf(true)), new UsesMethod("java.util.Comparator naturalOrder(..)", true), new UsesMethod("java.util.function.BinaryOperator minBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ComparatorsMaxRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.ComparatorsMax`";
        }

        public String getDescription() {
            return "Prefer a method reference to `Comparators#max(Comparable, Comparable)` over calling `BinaryOperator#minBy(Comparator)` with `Comparator#naturalOrder()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.function.BinaryOperator.maxBy(java.util.Comparator.naturalOrder())").bindType("java.util.function.BinaryOperator<T>").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.Comparator.naturalOrder");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.Comparators::max").bindType("java.util.function.BinaryOperator<T>").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.BinaryOperator", Boolean.valueOf(true)), new UsesMethod("java.util.Comparator naturalOrder(..)", true), new UsesMethod("java.util.function.BinaryOperator maxBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MinByNaturalOrderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.MinByNaturalOrder`";
        }

        public String getDescription() {
            return "Prefer `Comparator#naturalOrder()` over `Comparator#reverseOrder()` where possible.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.stream.Collectors.maxBy(java.util.Comparator.reverseOrder())").bindType("java.util.stream.Collector<T, ?, java.util.Optional<T>>").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collectors");
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.stream.Collectors.maxBy");
                        this.maybeRemoveImport("java.util.Comparator.reverseOrder");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.stream.Collectors.minBy(java.util.Comparator.naturalOrder())").bindType("java.util.stream.Collector<T, ?, java.util.Optional<T>>").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesMethod("java.util.Comparator reverseOrder(..)", true), new UsesMethod("java.util.stream.Collectors maxBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class MaxByNaturalOrderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.MaxByNaturalOrder`";
        }

        public String getDescription() {
            return "Prefer `Comparator#naturalOrder()` over `Comparator#reverseOrder()` where possible.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"java.util.stream.Collectors.minBy(java.util.Comparator.reverseOrder())").bindType("java.util.stream.Collector<T, ?, java.util.Optional<T>>").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Collectors");
                        this.maybeRemoveImport("java.util.Comparator");
                        this.maybeRemoveImport("java.util.stream.Collectors.minBy");
                        this.maybeRemoveImport("java.util.Comparator.reverseOrder");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.stream.Collectors.maxBy(java.util.Comparator.naturalOrder())").bindType("java.util.stream.Collector<T, ?, java.util.Optional<T>>").genericTypes(new String[]{"T extends java.lang.Comparable<? super T>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Optional", Boolean.valueOf(true)), new UsesType("java.util.stream.Collector", Boolean.valueOf(true)), new UsesMethod("java.util.Comparator reverseOrder(..)", true), new UsesMethod("java.util.stream.Collectors minBy(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IsLessThanRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.IsLessThan`";
        }

        public String getDescription() {
            return "Don't explicitly compare enums by their ordinal.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{value1:any(E)}.ordinal() < #{value2:any(E)}.ordinal()").genericTypes(new String[]{"E extends java.lang.Enum<E>"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{value1:any(E)}.compareTo(#{value2:any(E)}) < 0").genericTypes(new String[]{"E extends java.lang.Enum<E>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.Enum ordinal(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class IsLessThanOrEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ComparatorRules.IsLessThanOrEqualTo`";
        }

        public String getDescription() {
            return "Don't explicitly compare enums by their ordinal.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{value1:any(E)}.ordinal() <= #{value2:any(E)}.ordinal()").genericTypes(new String[]{"E extends java.lang.Enum<E>"}).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{value1:any(E)}.compareTo(#{value2:any(E)}) <= 0").genericTypes(new String[]{"E extends java.lang.Enum<E>"}).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitBinary(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.Enum ordinal(..)", true), (TreeVisitor)javaVisitor);
        }
    }
}

