/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class SpringTestRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`SpringTestRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to Spring Test expressions and statements.\n[Source](https://error-prone.picnic.tech/refasterrules/SpringTestRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new BodyContentSpecJsonLenientRecipe(), new BodyContentSpecJsonStrictRecipe()});
    }

    @NullMarked
    public static class BodyContentSpecJsonLenientRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `SpringTestRules.BodyContentSpecJsonLenient`";
        }

        public String getDescription() {
            return "Prefer `BodyContentSpec#json(String, JsonCompareMode)` over alternatives that implicitly perform a `JsonCompareMode#LENIENT lenient` comparison or are deprecated.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{spec:any(org.springframework.test.web.reactive.server.WebTestClient.BodyContentSpec)}.json(#{expectedJson:any(java.lang.String)})").bindType("org.springframework.test.web.reactive.server.WebTestClient.BodyContentSpec").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"spring-test-7"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{spec:any(org.springframework.test.web.reactive.server.WebTestClient.BodyContentSpec)}.json(#{expectedJson:any(java.lang.String)}, org.springframework.test.json.JsonCompareMode.LENIENT)").bindType("org.springframework.test.web.reactive.server.WebTestClient.BodyContentSpec").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"spring-test-7"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{spec:any(org.springframework.test.web.reactive.server.WebTestClient.BodyContentSpec)}.json(#{expectedJson:any(java.lang.String)}, false)").bindType("org.springframework.test.web.reactive.server.WebTestClient.BodyContentSpec").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"spring-test-7"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{spec:any(org.springframework.test.web.reactive.server.WebTestClient.BodyContentSpec)}.json(#{expectedJson:any(java.lang.String)}, org.springframework.test.json.JsonCompareMode.LENIENT)").bindType("org.springframework.test.web.reactive.server.WebTestClient.BodyContentSpec").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"spring-test-7"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.test.web.reactive.server.WebTestClient.BodyContentSpec", Boolean.valueOf(true)), new UsesMethod("org.springframework.test.web.reactive.server.WebTestClient.BodyContentSpec json(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class BodyContentSpecJsonStrictRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `SpringTestRules.BodyContentSpecJsonStrict`";
        }

        public String getDescription() {
            return "Prefer `BodyContentSpec#json(String, JsonCompareMode)` over the deprecated alternative.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{spec:any(org.springframework.test.web.reactive.server.WebTestClient.BodyContentSpec)}.json(#{expectedJson:any(java.lang.String)}, true)").bindType("org.springframework.test.web.reactive.server.WebTestClient.BodyContentSpec").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"spring-test-7"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{spec:any(org.springframework.test.web.reactive.server.WebTestClient.BodyContentSpec)}.json(#{expectedJson:any(java.lang.String)}, org.springframework.test.json.JsonCompareMode.STRICT)").bindType("org.springframework.test.web.reactive.server.WebTestClient.BodyContentSpec").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"spring-test-7"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.test.web.reactive.server.WebTestClient.BodyContentSpec", Boolean.valueOf(true)), new UsesMethod("org.springframework.test.web.reactive.server.WebTestClient.BodyContentSpec json(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

