/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;
import tech.picnic.errorprone.utils.ThirdPartyLibrary;

@BugPattern(summary="Avoid `Collectors.to{List,Map,Set}` in favor of collectors that emphasize (im)mutability", link="https://error-prone.picnic.tech/bugpatterns/CollectorMutability", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
@AutoService(value={BugChecker.class})
public final class CollectorMutability
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> COLLECTOR_METHOD = MethodMatchers.staticMethod().onClass(Collectors.class.getCanonicalName());
    private static final Matcher<ExpressionTree> LIST_COLLECTOR = MethodMatchers.staticMethod().anyClass().named("toList");
    private static final Matcher<ExpressionTree> MAP_COLLECTOR = MethodMatchers.staticMethod().anyClass().named("toMap");
    private static final Matcher<ExpressionTree> SET_COLLECTOR = MethodMatchers.staticMethod().anyClass().named("toSet");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!ThirdPartyLibrary.GUAVA.isIntroductionAllowed(state) || !COLLECTOR_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (LIST_COLLECTOR.matches((Tree)tree, state)) {
            return this.suggestToCollectionAlternatives(tree, ImmutableList.class.getCanonicalName() + ".toImmutableList", ArrayList.class.getCanonicalName(), state);
        }
        if (MAP_COLLECTOR.matches((Tree)tree, state)) {
            return this.suggestToMapAlternatives(tree, state);
        }
        if (SET_COLLECTOR.matches((Tree)tree, state)) {
            return this.suggestToCollectionAlternatives(tree, ImmutableSet.class.getCanonicalName() + ".toImmutableSet", HashSet.class.getCanonicalName(), state);
        }
        return Description.NO_MATCH;
    }

    private Description suggestToCollectionAlternatives(MethodInvocationTree tree, String immutableReplacement, String mutableReplacement, VisitorState state) {
        SuggestedFix.Builder mutableFix = SuggestedFix.builder();
        String toCollectionSelect = SuggestedFixes.qualifyStaticImport((String)(Collectors.class.getCanonicalName() + ".toCollection"), (SuggestedFix.Builder)mutableFix, (VisitorState)state);
        String mutableCollection = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)mutableFix, (String)mutableReplacement);
        return this.buildDescription(tree).addFix((Fix)CollectorMutability.replaceMethodInvocation(tree, immutableReplacement, state)).addFix((Fix)mutableFix.replace((Tree)tree, "%s(%s::new)".formatted(toCollectionSelect, mutableCollection)).build()).build();
    }

    private Description suggestToMapAlternatives(MethodInvocationTree tree, VisitorState state) {
        int argCount = tree.getArguments().size();
        if (argCount > 3) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder mutableFix = SuggestedFix.builder();
        String hashMap = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)mutableFix, (String)HashMap.class.getCanonicalName());
        return this.buildDescription(tree).addFix((Fix)CollectorMutability.replaceMethodInvocation(tree, ImmutableMap.class.getCanonicalName() + ".toImmutableMap", state)).addFix((Fix)mutableFix.postfixWith((Tree)tree.getArguments().get(argCount - 1), (argCount == 2 ? ", (a, b) -> { throw new IllegalStateException(); }" : "") + ", %s::new".formatted(hashMap)).build()).build();
    }

    private static SuggestedFix replaceMethodInvocation(MethodInvocationTree tree, String fullyQualifiedReplacement, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String replacement = SuggestedFixes.qualifyStaticImport((String)fullyQualifiedReplacement, (SuggestedFix.Builder)fix, (VisitorState)state);
        fix.merge(SuggestedFix.replace((Tree)tree.getMethodSelect(), (String)replacement));
        return fix.build();
    }
}

