/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import tech.picnic.errorprone.utils.MoreASTHelpers;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="Variable assignment is redundant; value can be returned directly", link="https://error-prone.picnic.tech/bugpatterns/DirectReturn", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class DirectReturn
extends BugChecker
implements BugChecker.BlockTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<StatementTree> VARIABLE_RETURN = Matchers.returnStatement((Matcher)Matchers.isVariable());
    private static final Matcher<ExpressionTree> MOCKITO_MOCK_OR_SPY_WITH_IMPLICIT_TYPE = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.toType(MethodInvocationTree.class, (Matcher)Matchers.argument((int)0, (Matcher)Matchers.isSameType((String)Class.class.getCanonicalName())))), Matchers.staticMethod().onClass("org.mockito.Mockito").namedAnyOf(new String[]{"mock", "spy"})});

    public Description matchBlock(BlockTree tree, VisitorState state) {
        List<? extends StatementTree> statements = tree.getStatements();
        if (statements.size() < 2) {
            return Description.NO_MATCH;
        }
        StatementTree finalStatement = statements.getLast();
        if (!VARIABLE_RETURN.matches((Tree)finalStatement, state)) {
            return Description.NO_MATCH;
        }
        Symbol variableSymbol = Objects.requireNonNull(ASTHelpers.getSymbol((Tree)((ReturnTree)finalStatement).getExpression()), "Missing symbol for returned variable");
        StatementTree precedingStatement = statements.get(statements.size() - 2);
        return DirectReturn.tryMatchAssignment(variableSymbol, precedingStatement).filter(resultExpr -> DirectReturn.canInlineToReturnStatement(resultExpr, state) && !DirectReturn.isIdentifierSymbolReferencedInAssociatedFinallyBlock(variableSymbol, state)).map(resultExpr -> this.describeMatch(precedingStatement, (Fix)SuggestedFix.builder().replace((Tree)precedingStatement, "return %s;".formatted(SourceCode.treeToString((Tree)resultExpr, (VisitorState)state))).delete((Tree)finalStatement).build())).orElse(Description.NO_MATCH);
    }

    private static Optional<ExpressionTree> tryMatchAssignment(Symbol targetSymbol, Tree tree) {
        Tree tree2 = tree;
        Objects.requireNonNull(tree2);
        Tree tree3 = tree2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExpressionStatementTree.class, AssignmentTree.class, VariableTree.class}, (Object)tree3, n)) {
            case 0 -> {
                ExpressionStatementTree expressionStatement = (ExpressionStatementTree)tree3;
                yield DirectReturn.tryMatchAssignment(targetSymbol, expressionStatement.getExpression());
            }
            case 1 -> {
                AssignmentTree assignment = (AssignmentTree)tree3;
                if (targetSymbol.equals(ASTHelpers.getSymbol((Tree)assignment.getVariable()))) {
                    yield Optional.of(assignment.getExpression());
                }
                yield Optional.empty();
            }
            case 2 -> {
                VariableTree declaration = (VariableTree)tree3;
                if (declaration.getModifiers().getAnnotations().isEmpty() && targetSymbol.equals(ASTHelpers.getSymbol((VariableTree)declaration))) {
                    yield Optional.ofNullable(declaration.getInitializer());
                }
                yield Optional.empty();
            }
            default -> Optional.empty();
        };
    }

    private static boolean canInlineToReturnStatement(ExpressionTree expressionTree, VisitorState state) {
        return !MOCKITO_MOCK_OR_SPY_WITH_IMPLICIT_TYPE.matches((Tree)expressionTree, state) || MoreASTHelpers.findMethodExitedOnReturn((VisitorState)state).filter(m -> MoreASTHelpers.areSameType((Tree)expressionTree, (Tree)m.getReturnType(), (VisitorState)state)).isPresent();
    }

    private static boolean isIdentifierSymbolReferencedInAssociatedFinallyBlock(Symbol symbol, VisitorState state) {
        return Streams.zip(Streams.stream((Iterable)state.getPath()).skip(1L), (Stream)Streams.stream((Iterable)state.getPath()), (tree, child) -> {
            if (!(tree instanceof TryTree)) {
                return null;
            }
            TryTree tryTree = (TryTree)tree;
            BlockTree finallyBlock = tryTree.getFinallyBlock();
            return !child.equals(finallyBlock) ? finallyBlock : null;
        }).anyMatch(finallyBlock -> DirectReturn.referencesIdentifierSymbol(symbol, finallyBlock));
    }

    private static boolean referencesIdentifierSymbol(final Symbol symbol, @Nullable BlockTree tree) {
        return Boolean.TRUE.equals(new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean visitIdentifier(IdentifierTree node, @Nullable Void unused) {
                return symbol.equals(ASTHelpers.getSymbol((Tree)node));
            }

            @Override
            public Boolean reduce(Boolean r1, Boolean r2) {
                return Boolean.TRUE.equals(r1) || Boolean.TRUE.equals(r2);
            }
        }.scan(tree, null));
    }
}

