/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.Optional;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="Empty method can likely be deleted", link="https://error-prone.picnic.tech/bugpatterns/EmptyMethod", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class EmptyMethod
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<Tree> PERMITTED_ANNOTATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isType((String)Override.class.getCanonicalName()), Matchers.isType((String)"org.aspectj.lang.annotation.Pointcut")}));

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (tree.getBody() == null || !tree.getBody().getStatements().isEmpty() || ASTHelpers.containsComments((Tree)tree, (VisitorState)state) || PERMITTED_ANNOTATION.matches((Tree)tree, state) || EmptyMethod.isInPossibleTestHelperClass(state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.methodCanBeOverridden((Symbol.MethodSymbol)ASTHelpers.getSymbol((MethodTree)tree))) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SourceCode.deleteWithTrailingWhitespace((Tree)tree, (VisitorState)state));
    }

    private static boolean isInPossibleTestHelperClass(VisitorState state) {
        return Optional.ofNullable((ClassTree)state.findEnclosing(new Class[]{ClassTree.class})).map(ClassTree::getSimpleName).filter(name -> name.toString().contains("Test")).isPresent();
    }
}

