/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tech.picnic.errorprone.utils.ThirdPartyLibrary;

@BugPattern(summary="Avoid iterating over `Flux`es in an implicitly blocking manner", link="https://error-prone.picnic.tech/bugpatterns/FluxImplicitBlock", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"Concurrency", "Performance"})
@AutoService(value={BugChecker.class})
public final class FluxImplicitBlock
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> FLUX_WITH_IMPLICIT_BLOCK = MethodMatchers.instanceMethod().onDescendantOf("reactor.core.publisher.Flux").namedAnyOf(new String[]{"toIterable", "toStream"}).withNoParameters();
    private static final Supplier<Type> STREAM = Suppliers.typeFromString((String)Stream.class.getCanonicalName());

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!FLUX_WITH_IMPLICIT_BLOCK.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree).addFix((Fix)SuggestedFixes.addSuppressWarnings((VisitorState)state, (String)this.canonicalName()));
        if (ThirdPartyLibrary.GUAVA.isIntroductionAllowed(state)) {
            description.addFix((Fix)FluxImplicitBlock.suggestBlockingElementCollection(tree, ImmutableList.class.getCanonicalName() + ".toImmutableList", state));
        }
        description.addFix((Fix)FluxImplicitBlock.suggestBlockingElementCollection(tree, Collectors.class.getCanonicalName() + ".toList", state));
        return description.build();
    }

    private static SuggestedFix suggestBlockingElementCollection(MethodInvocationTree tree, String fullyQualifiedCollectorMethod, VisitorState state) {
        SuggestedFix.Builder importSuggestion = SuggestedFix.builder();
        String replacementMethodInvocation = SuggestedFixes.qualifyStaticImport((String)fullyQualifiedCollectorMethod, (SuggestedFix.Builder)importSuggestion, (VisitorState)state);
        boolean isStream = ASTHelpers.isSubtype((Type)ASTHelpers.getResultType((ExpressionTree)tree), (Type)((Type)STREAM.get(state)), (VisitorState)state);
        String replacement = ".collect(%s()).block()%s".formatted(replacementMethodInvocation, isStream ? ".stream()" : "");
        return importSuggestion.merge(FluxImplicitBlock.replaceMethodInvocation(tree, replacement, state)).build();
    }

    private static SuggestedFix.Builder replaceMethodInvocation(MethodInvocationTree tree, String replacement, VisitorState state) {
        int startPosition = state.getEndPosition((Tree)ASTHelpers.getReceiver((ExpressionTree)tree));
        int endPosition = state.getEndPosition((Tree)tree);
        Preconditions.checkState((startPosition != -1 && endPosition != -1 ? 1 : 0) != 0, (Object)"Cannot locate method to be replaced in source code");
        return SuggestedFix.builder().replace(startPosition, endPosition, replacement);
    }
}

