/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.time.Instant;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractInstantAssert;
import org.assertj.core.api.Assertions;

final class AssertJInstantRules {
    private AssertJInstantRules() {
    }

    static final class AssertThatIsStrictlyBetween {
        AssertThatIsStrictlyBetween() {
        }

        AbstractInstantAssert<?> before(Instant actual, Instant start, Instant end) {
            return (AbstractInstantAssert)Refaster.anyOf((Object[])new AbstractInstantAssert[]{Assertions.assertThat((Instant)actual).isAfter(start).isBefore(end), Assertions.assertThat((Instant)actual).isBefore(end).isAfter(start)});
        }

        AbstractInstantAssert<?> after(Instant actual, Instant start, Instant end) {
            return Assertions.assertThat((Instant)actual).isStrictlyBetween(start, end);
        }
    }

    static final class AssertThatIsBetween {
        AssertThatIsBetween() {
        }

        AbstractInstantAssert<?> before(Instant actual, Instant start, Instant end) {
            return (AbstractInstantAssert)Refaster.anyOf((Object[])new AbstractInstantAssert[]{Assertions.assertThat((Instant)actual).isAfterOrEqualTo(start).isBeforeOrEqualTo(end), Assertions.assertThat((Instant)actual).isBeforeOrEqualTo(end).isAfterOrEqualTo(start)});
        }

        AbstractInstantAssert<?> after(Instant actual, Instant start, Instant end) {
            return Assertions.assertThat((Instant)actual).isBetween(start, end);
        }
    }

    static final class AssertThatIsAfterOrEqualTo {
        AssertThatIsAfterOrEqualTo() {
        }

        AbstractBooleanAssert<?> before(Instant actual, Instant other) {
            return Assertions.assertThat((boolean)actual.isBefore(other)).isFalse();
        }

        AbstractInstantAssert<?> after(Instant actual, Instant other) {
            return Assertions.assertThat((Instant)actual).isAfterOrEqualTo(other);
        }
    }

    static final class AssertThatIsBefore {
        AssertThatIsBefore() {
        }

        AbstractBooleanAssert<?> before(Instant actual, Instant other) {
            return Assertions.assertThat((boolean)actual.isBefore(other)).isTrue();
        }

        AbstractInstantAssert<?> after(Instant actual, Instant other) {
            return Assertions.assertThat((Instant)actual).isBefore(other);
        }
    }

    static final class AssertThatIsBeforeOrEqualTo {
        AssertThatIsBeforeOrEqualTo() {
        }

        AbstractBooleanAssert<?> before(Instant actual, Instant other) {
            return Assertions.assertThat((boolean)actual.isAfter(other)).isFalse();
        }

        AbstractInstantAssert<?> after(Instant actual, Instant other) {
            return Assertions.assertThat((Instant)actual).isBeforeOrEqualTo(other);
        }
    }

    static final class AssertThatIsAfter {
        AssertThatIsAfter() {
        }

        AbstractBooleanAssert<?> before(Instant actual, Instant other) {
            return Assertions.assertThat((boolean)actual.isAfter(other)).isTrue();
        }

        AbstractInstantAssert<?> after(Instant actual, Instant other) {
            return Assertions.assertThat((Instant)actual).isAfter(other);
        }
    }
}

