/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

final class MapRules {
    private MapRules() {
    }

    static final class MapValueStream<K, V> {
        MapValueStream() {
        }

        Stream<V> before(Map<K, V> map) {
            return map.entrySet().stream().map(Map.Entry::getValue);
        }

        Stream<V> after(Map<K, V> map) {
            return map.values().stream();
        }
    }

    static final class MapKeyStream<K, V> {
        MapKeyStream() {
        }

        Stream<K> before(Map<K, V> map) {
            return map.entrySet().stream().map(Map.Entry::getKey);
        }

        Stream<K> after(Map<K, V> map) {
            return map.keySet().stream();
        }
    }

    static final class MapContainsValue<K, V, T> {
        MapContainsValue() {
        }

        boolean before(Map<K, V> map, T value) {
            return map.values().contains(value);
        }

        boolean after(Map<K, V> map, T value) {
            return map.containsValue(value);
        }
    }

    static final class MapContainsKey<K, V, T> {
        MapContainsKey() {
        }

        boolean before(Map<K, V> map, T key) {
            return map.keySet().contains(key);
        }

        boolean after(Map<K, V> map, T key) {
            return map.containsKey(key);
        }
    }

    static final class MapSize<K, V> {
        MapSize() {
        }

        int before(Map<K, V> map) {
            return ((Collection)Refaster.anyOf((Object[])new Collection[]{map.keySet(), map.values(), map.entrySet()})).size();
        }

        int after(Map<K, V> map) {
            return map.size();
        }
    }

    static final class MapIsEmpty<K, V> {
        MapIsEmpty() {
        }

        boolean before(Map<K, V> map) {
            return ((Collection)Refaster.anyOf((Object[])new Collection[]{map.keySet(), map.values(), map.entrySet()})).isEmpty();
        }

        boolean after(Map<K, V> map) {
            return map.isEmpty();
        }
    }

    static final class MapGetOrDefault<K, V, T> {
        MapGetOrDefault() {
        }

        V before(Map<K, V> map, T key, V defaultValue) {
            return Objects.requireNonNullElse(map.get(key), defaultValue);
        }

        V after(Map<K, V> map, T key, V defaultValue) {
            return map.getOrDefault(key, defaultValue);
        }
    }

    static final class MapGetOrNull<K, V, T> {
        MapGetOrNull() {
        }

        @Nullable V before(Map<K, V> map, T key) {
            return map.getOrDefault(key, null);
        }

        @Nullable V after(Map<K, V> map, T key) {
            return map.get(key);
        }
    }

    static final class CreateEnumMap<K extends Enum<K>, V> {
        CreateEnumMap() {
        }

        Map<K, V> before() {
            return new HashMap();
        }

        Map<K, V> after() {
            return new EnumMap(Refaster.clazz());
        }
    }
}

