/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;

final class MockitoRules {
    private MockitoRules() {
    }

    static final class InvocationOnMockGetArgumentsWithTypeParameter<T> {
        InvocationOnMockGetArgumentsWithTypeParameter() {
        }

        T before(InvocationOnMock invocation, int i) {
            return (T)Refaster.anyOf((Object[])new Object[]{invocation.getArgument(i, Refaster.clazz()), invocation.getArgument(i)});
        }

        T after(InvocationOnMock invocation, int i) {
            return (T)invocation.getArgument(i);
        }
    }

    static final class InvocationOnMockGetArguments {
        InvocationOnMockGetArguments() {
        }

        Object before(InvocationOnMock invocation, int i) {
            return invocation.getArguments()[i];
        }

        Object after(InvocationOnMock invocation, int i) {
            return invocation.getArgument(i);
        }
    }

    static final class VerifyOnce<T> {
        VerifyOnce() {
        }

        T before(T mock) {
            return (T)Mockito.verify(mock, (VerificationMode)Mockito.times((int)1));
        }

        T after(T mock) {
            return (T)Mockito.verify(mock);
        }
    }

    static final class Never {
        Never() {
        }

        VerificationMode before() {
            return Mockito.times((int)0);
        }

        VerificationMode after() {
            return Mockito.never();
        }
    }
}

