/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import org.springframework.http.HttpMethod;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;

final class WebClientRules {
    private WebClientRules() {
    }

    static final class RequestHeadersUriSpecUri {
        RequestHeadersUriSpecUri() {
        }

        WebClient.RequestHeadersSpec<?> before(WebClient.RequestHeadersUriSpec<?> requestHeadersUriSpec, String path, Object uriVariables) {
            return requestHeadersUriSpec.uri(uriBuilder -> uriBuilder.path(path).build(Refaster.asVarargs((Object)uriVariables)));
        }

        WebTestClient.RequestHeadersSpec<?> before(WebTestClient.RequestHeadersUriSpec<?> requestHeadersUriSpec, String path, Object uriVariables) {
            return requestHeadersUriSpec.uri(uriBuilder -> uriBuilder.path(path).build(Refaster.asVarargs((Object)uriVariables)));
        }

        WebClient.RequestHeadersSpec<?> after(WebClient.RequestHeadersUriSpec<?> requestHeadersUriSpec, String path, Object uriVariables) {
            return requestHeadersUriSpec.uri(path, Refaster.asVarargs((Object)uriVariables));
        }
    }

    static final class WebClientPut {
        WebClientPut() {
        }

        WebClient.RequestBodyUriSpec before(WebClient webClient) {
            return webClient.method(HttpMethod.PUT);
        }

        WebTestClient.RequestBodyUriSpec before(WebTestClient webClient) {
            return webClient.method(HttpMethod.PUT);
        }

        WebClient.RequestBodyUriSpec after(WebClient webClient) {
            return webClient.put();
        }
    }

    static final class WebClientPost {
        WebClientPost() {
        }

        WebClient.RequestBodyUriSpec before(WebClient webClient) {
            return webClient.method(HttpMethod.POST);
        }

        WebTestClient.RequestBodyUriSpec before(WebTestClient webClient) {
            return webClient.method(HttpMethod.POST);
        }

        WebClient.RequestBodyUriSpec after(WebClient webClient) {
            return webClient.post();
        }
    }

    static final class WebClientPatch {
        WebClientPatch() {
        }

        WebClient.RequestBodyUriSpec before(WebClient webClient) {
            return webClient.method(HttpMethod.PATCH);
        }

        WebTestClient.RequestBodyUriSpec before(WebTestClient webClient) {
            return webClient.method(HttpMethod.PATCH);
        }

        WebClient.RequestBodyUriSpec after(WebClient webClient) {
            return webClient.patch();
        }
    }

    static final class WebClientOptions {
        WebClientOptions() {
        }

        WebClient.RequestHeadersSpec<?> before(WebClient webClient) {
            return webClient.method(HttpMethod.OPTIONS);
        }

        WebTestClient.RequestHeadersSpec<?> before(WebTestClient webClient) {
            return webClient.method(HttpMethod.OPTIONS);
        }

        WebClient.RequestHeadersSpec<?> after(WebClient webClient) {
            return webClient.options();
        }
    }

    static final class WebClientHead {
        WebClientHead() {
        }

        WebClient.RequestHeadersSpec<?> before(WebClient webClient) {
            return webClient.method(HttpMethod.HEAD);
        }

        WebTestClient.RequestHeadersSpec<?> before(WebTestClient webClient) {
            return webClient.method(HttpMethod.HEAD);
        }

        WebClient.RequestHeadersSpec<?> after(WebClient webClient) {
            return webClient.head();
        }
    }

    static final class WebClientGet {
        WebClientGet() {
        }

        WebClient.RequestHeadersSpec<?> before(WebClient webClient) {
            return webClient.method(HttpMethod.GET);
        }

        WebTestClient.RequestHeadersSpec<?> before(WebTestClient webClient) {
            return webClient.method(HttpMethod.GET);
        }

        WebClient.RequestHeadersSpec<?> after(WebClient webClient) {
            return webClient.get();
        }
    }

    static final class BodyValue<T> {
        BodyValue() {
        }

        WebClient.RequestHeadersSpec<?> before(WebClient.RequestBodySpec requestBodySpec, T value) {
            return requestBodySpec.body(BodyInserters.fromValue(value));
        }

        WebTestClient.RequestHeadersSpec<?> before(WebTestClient.RequestBodySpec requestBodySpec, T value) {
            return requestBodySpec.body(BodyInserters.fromValue(value));
        }

        WebClient.RequestHeadersSpec<?> after(WebClient.RequestBodySpec requestBodySpec, T value) {
            return requestBodySpec.bodyValue(value);
        }
    }
}

