/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refaster.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;

public final class RequiresComputation
implements Matcher<ExpressionTree> {
    private static final long serialVersionUID = 1L;

    public boolean matches(ExpressionTree expressionTree, VisitorState state) {
        return RequiresComputation.matches(expressionTree);
    }

    private static boolean matches(ExpressionTree expressionTree) {
        if (expressionTree instanceof ArrayAccessTree) {
            ArrayAccessTree arrayAccess = (ArrayAccessTree)expressionTree;
            return RequiresComputation.matches(arrayAccess.getExpression()) || RequiresComputation.matches(arrayAccess.getIndex());
        }
        if (expressionTree instanceof LiteralTree) {
            return false;
        }
        if (expressionTree instanceof LambdaExpressionTree) {
            return false;
        }
        if (expressionTree instanceof IdentifierTree) {
            return false;
        }
        if (expressionTree instanceof MemberReferenceTree) {
            MemberReferenceTree memberReference = (MemberReferenceTree)expressionTree;
            return RequiresComputation.matches(memberReference.getQualifierExpression());
        }
        if (expressionTree instanceof MemberSelectTree) {
            MemberSelectTree memberSelect = (MemberSelectTree)expressionTree;
            return RequiresComputation.matches(memberSelect.getExpression());
        }
        if (expressionTree instanceof ParenthesizedTree) {
            ParenthesizedTree parenthesized = (ParenthesizedTree)expressionTree;
            return RequiresComputation.matches(parenthesized.getExpression());
        }
        if (expressionTree instanceof TypeCastTree) {
            TypeCastTree typeCast = (TypeCastTree)expressionTree;
            return RequiresComputation.matches(typeCast.getExpression());
        }
        if (expressionTree instanceof UnaryTree) {
            UnaryTree unary = (UnaryTree)expressionTree;
            return RequiresComputation.matches(unary.getExpression());
        }
        return ASTHelpers.constValue((Tree)expressionTree) == null;
    }
}

