/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.function;

import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apiguardian.api.API;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.internal.function.Calculator;
import tech.units.indriya.quantity.Quantities;

@API(status=API.Status.INTERNAL)
public final class ScaleHelper {
    public static boolean isAbsolute(Quantity<?> quantity) {
        return Quantity.Scale.ABSOLUTE == quantity.getScale();
    }

    public static boolean isRelative(Quantity<?> quantity) {
        return Quantity.Scale.RELATIVE == quantity.getScale();
    }

    public static <Q extends Quantity<Q>> ComparableQuantity<Q> convertTo(Quantity<Q> quantity, Unit<Q> anotherUnit) {
        UnitConverter converter = quantity.getUnit().getConverterTo(anotherUnit);
        if (ScaleHelper.isRelative(quantity)) {
            Number linearFactor = ScaleHelper.linearFactorOf(converter).orElse(null);
            if (linearFactor == null) {
                throw ScaleHelper.unsupportedRelativeScaleConversion(quantity, anotherUnit);
            }
            Number valueInOtherUnit = Calculator.of(linearFactor).multiply(quantity.getValue()).peek();
            return Quantities.getQuantity(valueInOtherUnit, anotherUnit, Quantity.Scale.RELATIVE);
        }
        Number convertedValue = converter.convert(quantity.getValue());
        return Quantities.getQuantity(convertedValue, anotherUnit, Quantity.Scale.ABSOLUTE);
    }

    public static <Q extends Quantity<Q>> ComparableQuantity<Q> addition(Quantity<Q> q1, Quantity<Q> q2, BinaryOperator<Number> operator) {
        boolean yieldsRelativeScale = OperandMode.get(q1, q2).isAllRelative();
        ToSystemUnitConverter thisConverter = ScaleHelper.toSystemUnitConverterForAdd(q1, q1);
        ToSystemUnitConverter thatConverter = ScaleHelper.toSystemUnitConverterForAdd(q1, q2);
        Number thisValueInSystemUnit = thisConverter.apply(q1.getValue());
        Number thatValueInSystemUnit = thatConverter.apply(q2.getValue());
        Number resultValueInSystemUnit = (Number)operator.apply(thisValueInSystemUnit, thatValueInSystemUnit);
        if (yieldsRelativeScale) {
            return Quantities.getQuantity(thisConverter.invert(resultValueInSystemUnit), q1.getUnit(), Quantity.Scale.RELATIVE);
        }
        boolean needsInvering = !thisConverter.isNoop() || !thatConverter.isNoop();
        Number resultValueInThisUnit = needsInvering ? (Number)q1.getUnit().getConverterTo(q1.getUnit().getSystemUnit()).inverse().convert(resultValueInSystemUnit) : (Number)resultValueInSystemUnit;
        return Quantities.getQuantity(resultValueInThisUnit, q1.getUnit(), Quantity.Scale.ABSOLUTE);
    }

    public static <Q extends Quantity<Q>> ComparableQuantity<Q> scalarMultiplication(Quantity<Q> quantity, UnaryOperator<Number> operator) {
        if (ScaleHelper.isRelative(quantity)) {
            return Quantities.getQuantity((Number)operator.apply(quantity.getValue()), quantity.getUnit(), Quantity.Scale.RELATIVE);
        }
        ToSystemUnitConverter toSystemUnits = ScaleHelper.toSystemUnitConverterForMul(quantity);
        Number thisValueWithAbsoluteScale = toSystemUnits.apply(quantity.getValue());
        Number resultValueInAbsUnits = (Number)operator.apply(thisValueWithAbsoluteScale);
        boolean needsInvering = !toSystemUnits.isNoop();
        Number resultValueInThisUnit = needsInvering ? (Number)quantity.getUnit().getConverterTo(quantity.getUnit().getSystemUnit()).inverse().convert(resultValueInAbsUnits) : (Number)resultValueInAbsUnits;
        return Quantities.getQuantity(resultValueInThisUnit, quantity.getUnit(), quantity.getScale());
    }

    public static ComparableQuantity<?> multiplication(Quantity<?> q1, Quantity<?> q2, BinaryOperator<Number> amountOperator, BinaryOperator<Unit<?>> unitOperator) {
        Quantity<?> absQ1 = ScaleHelper.toAbsoluteLinear(q1);
        Quantity<?> absQ2 = ScaleHelper.toAbsoluteLinear(q2);
        return Quantities.getQuantity((Number)amountOperator.apply(absQ1.getValue(), absQ2.getValue()), (Unit)unitOperator.apply(absQ1.getUnit(), absQ2.getUnit()));
    }

    private static <Q extends Quantity<Q>> Quantity<Q> toAbsoluteLinear(Quantity<Q> quantity) {
        Unit systemUnit = quantity.getUnit().getSystemUnit();
        UnitConverter toSystemUnit = quantity.getUnit().getConverterTo(systemUnit);
        if (toSystemUnit.isLinear()) {
            if (ScaleHelper.isAbsolute(quantity)) {
                return quantity;
            }
            return Quantities.getQuantity(quantity.getValue(), quantity.getUnit());
        }
        if (ScaleHelper.isAbsolute(quantity)) {
            return Quantities.getQuantity(toSystemUnit.convert(quantity.getValue()), systemUnit, Quantity.Scale.ABSOLUTE);
        }
        Number linearFactor = ScaleHelper.linearFactorOf(toSystemUnit).orElse(null);
        if (linearFactor == null) {
            throw ScaleHelper.unsupportedRelativeScaleConversion(quantity, systemUnit);
        }
        Number valueInSystemUnits = Calculator.of(linearFactor).multiply(quantity.getValue()).peek();
        return Quantities.getQuantity(valueInSystemUnits, systemUnit, Quantity.Scale.ABSOLUTE);
    }

    private static <Q extends Quantity<Q>> ToSystemUnitConverter toSystemUnitConverterForAdd(Quantity<Q> q1, Quantity<Q> q2) {
        Unit systemUnit = q1.getUnit().getSystemUnit();
        return ToSystemUnitConverter.forQuantity(q2, systemUnit);
    }

    private static <T extends Quantity<T>> ToSystemUnitConverter toSystemUnitConverterForMul(Quantity<T> quantity) {
        Unit systemUnit = quantity.getUnit().getSystemUnit();
        return ToSystemUnitConverter.forQuantity(quantity, systemUnit);
    }

    private static Optional<Number> linearFactorOf(UnitConverter converter) {
        return converter instanceof AbstractConverter ? ((AbstractConverter)converter).linearFactor() : Optional.empty();
    }

    private static <Q extends Quantity<Q>> UnsupportedOperationException unsupportedRelativeScaleConversion(Quantity<Q> quantity, Unit<Q> anotherUnit) {
        return new UnsupportedOperationException(String.format("Conversion of Quantitity %s to Unit %s is not supported for realtive scale.", quantity, anotherUnit));
    }

    private static UnsupportedOperationException unsupportedConverter(UnitConverter converter, Unit<?> unit) {
        return new UnsupportedOperationException(String.format("Scale conversion from RELATIVE to ABSOLUTE for Unit %s having Converter %s is not implemented.", unit, converter));
    }

    private static enum OperandMode {
        ALL_ABSOLUTE,
        ALL_RELATIVE,
        MIXED;


        public static OperandMode get(Quantity<?> q1, Quantity<?> q2) {
            if (q1.getScale() != q2.getScale()) {
                return MIXED;
            }
            return ScaleHelper.isAbsolute(q1) ? ALL_ABSOLUTE : ALL_RELATIVE;
        }

        public boolean isAllRelative() {
            return this == ALL_RELATIVE;
        }
    }

    private static class ToSystemUnitConverter
    implements UnaryOperator<Number> {
        private final UnaryOperator<Number> unaryOperator;
        private final UnaryOperator<Number> inverseOperator;

        public static <Q extends Quantity<Q>> ToSystemUnitConverter forQuantity(Quantity<Q> quantity, Unit<Q> systemUnit) {
            if (quantity.getUnit().equals(systemUnit)) {
                return ToSystemUnitConverter.noop();
            }
            UnitConverter converter = quantity.getUnit().getConverterTo(systemUnit);
            if (ScaleHelper.isAbsolute(quantity)) {
                return ToSystemUnitConverter.of(arg_0 -> ((UnitConverter)converter).convert(arg_0));
            }
            Number linearFactor = ScaleHelper.linearFactorOf(converter).orElse(null);
            if (linearFactor != null) {
                return ToSystemUnitConverter.factor(linearFactor);
            }
            throw ScaleHelper.unsupportedConverter(converter, quantity.getUnit());
        }

        public Number invert(Number x) {
            return this.isNoop() ? (Number)x : (Number)((Number)this.inverseOperator.apply(x));
        }

        public static ToSystemUnitConverter of(UnaryOperator<Number> unaryOperator) {
            return new ToSystemUnitConverter(unaryOperator, null);
        }

        public static ToSystemUnitConverter noop() {
            return new ToSystemUnitConverter(null, null);
        }

        public static ToSystemUnitConverter factor(Number factor) {
            return new ToSystemUnitConverter(number -> Calculator.of(number).multiply(factor).peek(), number -> Calculator.of(number).divide(factor).peek());
        }

        private ToSystemUnitConverter(UnaryOperator<Number> unaryOperator, UnaryOperator<Number> inverseOperator) {
            this.unaryOperator = unaryOperator;
            this.inverseOperator = inverseOperator;
        }

        public boolean isNoop() {
            return this.unaryOperator == null;
        }

        @Override
        public Number apply(Number x) {
            return this.isNoop() ? (Number)x : (Number)((Number)this.unaryOperator.apply(x));
        }
    }
}

