// CHECKSTYLE:OFF

package com.testdroid.jenkins;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * %s received a REST request to the JSON endpoint.
     * 
     */
    public static String RECEIVED_REST_JSON() {
        return holder.format("RECEIVED_REST_JSON");
    }

    /**
     * %s received a REST request to the JSON endpoint.
     * 
     */
    public static Localizable _RECEIVED_REST_JSON() {
        return new Localizable(holder, "RECEIVED_REST_JSON");
    }

    /**
     * Authorization error. Please check email and password
     * 
     */
    public static String ERROR_AUTHORIZATION() {
        return holder.format("ERROR_AUTHORIZATION");
    }

    /**
     * Authorization error. Please check email and password
     * 
     */
    public static Localizable _ERROR_AUTHORIZATION() {
        return new Localizable(holder, "ERROR_AUTHORIZATION");
    }

    /**
     * Locale
     * 
     */
    public static String LOCALE() {
        return holder.format("LOCALE");
    }

    /**
     * Locale
     * 
     */
    public static Localizable _LOCALE() {
        return new Localizable(holder, "LOCALE");
    }

    /**
     * Please check project name
     * 
     */
    public static String CHECK_PROJECT_NAME() {
        return holder.format("CHECK_PROJECT_NAME");
    }

    /**
     * Please check project name
     * 
     */
    public static Localizable _CHECK_PROJECT_NAME() {
        return new Localizable(holder, "CHECK_PROJECT_NAME");
    }

    /**
     * Current test run status
     * 
     */
    public static String STATUS_TIP() {
        return holder.format("STATUS_TIP");
    }

    /**
     * Current test run status
     * 
     */
    public static Localizable _STATUS_TIP() {
        return new Localizable(holder, "STATUS_TIP");
    }

    /**
     * Couldn't find the credentials '%s'
     * 
     */
    public static String COULDNT_FIND_CREDENTIALS() {
        return holder.format("COULDNT_FIND_CREDENTIALS");
    }

    /**
     * Couldn't find the credentials '%s'
     * 
     */
    public static Localizable _COULDNT_FIND_CREDENTIALS() {
        return new Localizable(holder, "COULDNT_FIND_CREDENTIALS");
    }

    /**
     * Bitbar: Run tests in Bitbar Cloud
     * 
     */
    public static String TESTDROID_RUN_TESTS_IN_CLOUD() {
        return holder.format("TESTDROID_RUN_TESTS_IN_CLOUD");
    }

    /**
     * Bitbar: Run tests in Bitbar Cloud
     * 
     */
    public static Localizable _TESTDROID_RUN_TESTS_IN_CLOUD() {
        return new Localizable(holder, "TESTDROID_RUN_TESTS_IN_CLOUD");
    }

    /**
     * Empty project name
     * 
     */
    public static String EMPTY_PROJECT() {
        return holder.format("EMPTY_PROJECT");
    }

    /**
     * Empty project name
     * 
     */
    public static Localizable _EMPTY_PROJECT() {
        return new Localizable(holder, "EMPTY_PROJECT");
    }

    /**
     * unlimited
     * 
     */
    public static String UNLIMITED() {
        return holder.format("UNLIMITED");
    }

    /**
     * unlimited
     * 
     */
    public static Localizable _UNLIMITED() {
        return new Localizable(holder, "UNLIMITED");
    }

    /**
     * Uploading new instrumentation file %s
     * 
     */
    public static String UPLOADING_NEW_INSTRUMENTATION_S() {
        return holder.format("UPLOADING_NEW_INSTRUMENTATION_S");
    }

    /**
     * Uploading new instrumentation file %s
     * 
     */
    public static Localizable _UPLOADING_NEW_INSTRUMENTATION_S() {
        return new Localizable(holder, "UPLOADING_NEW_INSTRUMENTATION_S");
    }

    /**
     * Bitbar Cloud (success rate)
     * 
     */
    public static String COLUMN_SUCCESS_RATE() {
        return holder.format("COLUMN_SUCCESS_RATE");
    }

    /**
     * Bitbar Cloud (success rate)
     * 
     */
    public static Localizable _COLUMN_SUCCESS_RATE() {
        return new Localizable(holder, "COLUMN_SUCCESS_RATE");
    }

    /**
     * On success only
     * 
     */
    public static String ON_SUCCESS_ONLY() {
        return holder.format("ON_SUCCESS_ONLY");
    }

    /**
     * On success only
     * 
     */
    public static Localizable _ON_SUCCESS_ONLY() {
        return new Localizable(holder, "ON_SUCCESS_ONLY");
    }

    /**
     * Not available
     * 
     */
    public static String PROGRESS_ERROR() {
        return holder.format("PROGRESS_ERROR");
    }

    /**
     * Not available
     * 
     */
    public static Localizable _PROGRESS_ERROR() {
        return new Localizable(holder, "PROGRESS_ERROR");
    }

    /**
     * Status
     * 
     */
    public static String STATUS() {
        return holder.format("STATUS");
    }

    /**
     * Status
     * 
     */
    public static Localizable _STATUS() {
        return new Localizable(holder, "STATUS");
    }

    /**
     * Uploading data file %s
     * 
     */
    public static String UPLOADING_DATA_FILE_S() {
        return holder.format("UPLOADING_DATA_FILE_S");
    }

    /**
     * Uploading data file %s
     * 
     */
    public static Localizable _UPLOADING_DATA_FILE_S() {
        return new Localizable(holder, "UPLOADING_DATA_FILE_S");
    }

    /**
     * Not available
     * 
     */
    public static String STATUS_ERROR() {
        return holder.format("STATUS_ERROR");
    }

    /**
     * Not available
     * 
     */
    public static Localizable _STATUS_ERROR() {
        return new Localizable(holder, "STATUS_ERROR");
    }

    /**
     * Username (email)
     * 
     */
    public static String USER_EMAIL() {
        return holder.format("USER_EMAIL");
    }

    /**
     * Username (email)
     * 
     */
    public static Localizable _USER_EMAIL() {
        return new Localizable(holder, "USER_EMAIL");
    }

    /**
     * Failed getting device clusters
     * 
     */
    public static String ERROR_GET_CLUSTER() {
        return holder.format("ERROR_GET_CLUSTER");
    }

    /**
     * Failed getting device clusters
     * 
     */
    public static Localizable _ERROR_GET_CLUSTER() {
        return new Localizable(holder, "ERROR_GET_CLUSTER");
    }

    /**
     * Test run finished without error on %d'%' of devices
     * 
     */
    public static String SUCCESS_RATE_PROGRESS_TIP() {
        return holder.format("SUCCESS_RATE_PROGRESS_TIP");
    }

    /**
     * Test run finished without error on %d'%' of devices
     * 
     */
    public static Localizable _SUCCESS_RATE_PROGRESS_TIP() {
        return new Localizable(holder, "SUCCESS_RATE_PROGRESS_TIP");
    }

    /**
     * %d'%' of devices have finished
     * 
     */
    public static String PROGRESS_PROGRESS_TIP() {
        return holder.format("PROGRESS_PROGRESS_TIP");
    }

    /**
     * %d'%' of devices have finished
     * 
     */
    public static Localizable _PROGRESS_PROGRESS_TIP() {
        return new Localizable(holder, "PROGRESS_PROGRESS_TIP");
    }

    /**
     * Run only on one device from group
     * 
     */
    public static String SCHEDULER_SINGLE() {
        return holder.format("SCHEDULER_SINGLE");
    }

    /**
     * Run only on one device from group
     * 
     */
    public static Localizable _SCHEDULER_SINGLE() {
        return new Localizable(holder, "SCHEDULER_SINGLE");
    }

    /**
     * Cloud URL '%s' was specified but no credentials. Using default URL '%s'
     * 
     */
    public static String CLOUD_URL_SET_BUT_NO_CREDENTIALS() {
        return holder.format("CLOUD_URL_SET_BUT_NO_CREDENTIALS");
    }

    /**
     * Cloud URL '%s' was specified but no credentials. Using default URL '%s'
     * 
     */
    public static Localizable _CLOUD_URL_SET_BUT_NO_CREDENTIALS() {
        return new Localizable(holder, "CLOUD_URL_SET_BUT_NO_CREDENTIALS");
    }

    /**
     * User %s is a free user. Forcing timeout 10 minutes!
     * 
     */
    public static String FREE_USERS_MAX_10_MINS() {
        return holder.format("FREE_USERS_MAX_10_MINS");
    }

    /**
     * User %s is a free user. Forcing timeout 10 minutes!
     * 
     */
    public static Localizable _FREE_USERS_MAX_10_MINS() {
        return new Localizable(holder, "FREE_USERS_MAX_10_MINS");
    }

    /**
     * Run on all devices simultaneously
     * 
     */
    public static String SCHEDULER_PARALLEL() {
        return holder.format("SCHEDULER_PARALLEL");
    }

    /**
     * Run on all devices simultaneously
     * 
     */
    public static Localizable _SCHEDULER_PARALLEL() {
        return new Localizable(holder, "SCHEDULER_PARALLEL");
    }

    /**
     * Run on one device at a time
     * 
     */
    public static String SCHEDULER_SERIAL() {
        return holder.format("SCHEDULER_SERIAL");
    }

    /**
     * Run on one device at a time
     * 
     */
    public static Localizable _SCHEDULER_SERIAL() {
        return new Localizable(holder, "SCHEDULER_SERIAL");
    }

    /**
     * Succeeded and failed tests on devices
     * 
     */
    public static String SUCCESS_RATE_TIP() {
        return holder.format("SUCCESS_RATE_TIP");
    }

    /**
     * Succeeded and failed tests on devices
     * 
     */
    public static Localizable _SUCCESS_RATE_TIP() {
        return new Localizable(holder, "SUCCESS_RATE_TIP");
    }

    /**
     * Timeout
     * 
     */
    public static String TIMEOUT() {
        return holder.format("TIMEOUT");
    }

    /**
     * Timeout
     * 
     */
    public static Localizable _TIMEOUT() {
        return new Localizable(holder, "TIMEOUT");
    }

    /**
     * Application file %s does not differ from latest version in Cloud - not uploading
     * 
     */
    public static String APPLICATION_S_NOT_CHANGED_NOT_UPLOADING() {
        return holder.format("APPLICATION_S_NOT_CHANGED_NOT_UPLOADING");
    }

    /**
     * Application file %s does not differ from latest version in Cloud - not uploading
     * 
     */
    public static Localizable _APPLICATION_S_NOT_CHANGED_NOT_UPLOADING() {
        return new Localizable(holder, "APPLICATION_S_NOT_CHANGED_NOT_UPLOADING");
    }

    /**
     * Running tests
     * 
     */
    public static String RUNNING_TESTS() {
        return holder.format("RUNNING_TESTS");
    }

    /**
     * Running tests
     * 
     */
    public static Localizable _RUNNING_TESTS() {
        return new Localizable(holder, "RUNNING_TESTS");
    }

    /**
     * Run test in Bitbar Cloud process started...
     * 
     */
    public static String RUN_TEST_IN_CLOUD_STARTED() {
        return holder.format("RUN_TEST_IN_CLOUD_STARTED");
    }

    /**
     * Run test in Bitbar Cloud process started...
     * 
     */
    public static Localizable _RUN_TEST_IN_CLOUD_STARTED() {
        return new Localizable(holder, "RUN_TEST_IN_CLOUD_STARTED");
    }

    /**
     * Empty instrumentation path
     * 
     */
    public static String ERROR_INSTRUMENTATION_PATH() {
        return holder.format("ERROR_INSTRUMENTATION_PATH");
    }

    /**
     * Empty instrumentation path
     * 
     */
    public static Localizable _ERROR_INSTRUMENTATION_PATH() {
        return new Localizable(holder, "ERROR_INSTRUMENTATION_PATH");
    }

    /**
     * Bitbar Cloud (finished progress)
     * 
     */
    public static String COLUMN_PROGRESS() {
        return holder.format("COLUMN_PROGRESS");
    }

    /**
     * Bitbar Cloud (finished progress)
     * 
     */
    public static Localizable _COLUMN_PROGRESS() {
        return new Localizable(holder, "COLUMN_PROGRESS");
    }

    /**
     * Progress
     * 
     */
    public static String PROGRESS() {
        return holder.format("PROGRESS");
    }

    /**
     * Progress
     * 
     */
    public static Localizable _PROGRESS() {
        return new Localizable(holder, "PROGRESS");
    }

    /**
     * Scheduler
     * 
     */
    public static String SCHEDULER() {
        return holder.format("SCHEDULER");
    }

    /**
     * Scheduler
     * 
     */
    public static Localizable _SCHEDULER() {
        return new Localizable(holder, "SCHEDULER");
    }

    /**
     * Project
     * 
     */
    public static String PROJECT() {
        return holder.format("PROJECT");
    }

    /**
     * Project
     * 
     */
    public static Localizable _PROJECT() {
        return new Localizable(holder, "PROJECT");
    }

    /**
     * Using test run configuration:
     * 
     */
    public static String TEST_RUN_CONFIGURATION() {
        return holder.format("TEST_RUN_CONFIGURATION");
    }

    /**
     * Using test run configuration:
     * 
     */
    public static Localizable _TEST_RUN_CONFIGURATION() {
        return new Localizable(holder, "TEST_RUN_CONFIGURATION");
    }

    /**
     * %s: the request did not contain the parameter 'testRunId'. Ignoring.
     * 
     */
    public static String REQUEST_NEEDS_TESTRUNID() {
        return holder.format("REQUEST_NEEDS_TESTRUNID");
    }

    /**
     * %s: the request did not contain the parameter 'testRunId'. Ignoring.
     * 
     */
    public static Localizable _REQUEST_NEEDS_TESTRUNID() {
        return new Localizable(holder, "REQUEST_NEEDS_TESTRUNID");
    }

    /**
     * Not available
     * 
     */
    public static String SUCCESS_RATE_ERROR() {
        return holder.format("SUCCESS_RATE_ERROR");
    }

    /**
     * Not available
     * 
     */
    public static Localizable _SUCCESS_RATE_ERROR() {
        return new Localizable(holder, "SUCCESS_RATE_ERROR");
    }

    /**
     * Bitbar Cloud URL
     * 
     */
    public static String CLOUD_URL() {
        return holder.format("CLOUD_URL");
    }

    /**
     * Bitbar Cloud URL
     * 
     */
    public static Localizable _CLOUD_URL() {
        return new Localizable(holder, "CLOUD_URL");
    }

    /**
     * Bitbar Run-in-Cloud Plugin
     * 
     */
    public static String PLUGIN_NAME() {
        return holder.format("PLUGIN_NAME");
    }

    /**
     * Bitbar Run-in-Cloud Plugin
     * 
     */
    public static Localizable _PLUGIN_NAME() {
        return new Localizable(holder, "PLUGIN_NAME");
    }

    /**
     * Using login details from the credentials manager, which overrides basic username/password specified in settings.
     * 
     */
    public static String BUILD_STEP_USING_CREDENTIALS() {
        return holder.format("BUILD_STEP_USING_CREDENTIALS");
    }

    /**
     * Using login details from the credentials manager, which overrides basic username/password specified in settings.
     * 
     */
    public static Localizable _BUILD_STEP_USING_CREDENTIALS() {
        return new Localizable(holder, "BUILD_STEP_USING_CREDENTIALS");
    }

    /**
     * On failure only
     * 
     */
    public static String ON_FAILURE_ONLY() {
        return holder.format("ON_FAILURE_ONLY");
    }

    /**
     * On failure only
     * 
     */
    public static Localizable _ON_FAILURE_ONLY() {
        return new Localizable(holder, "ON_FAILURE_ONLY");
    }

    /**
     * A problem occurred downloading results from Cloud
     * 
     */
    public static String DOWNLOAD_RESULTS_FAILED() {
        return holder.format("DOWNLOAD_RESULTS_FAILED");
    }

    /**
     * A problem occurred downloading results from Cloud
     * 
     */
    public static Localizable _DOWNLOAD_RESULTS_FAILED() {
        return new Localizable(holder, "DOWNLOAD_RESULTS_FAILED");
    }

    /**
     * Run test in Bitbar Cloud succeeded
     * 
     */
    public static String RUN_TEST_IN_CLOUD_SUCCEEDED() {
        return holder.format("RUN_TEST_IN_CLOUD_SUCCEEDED");
    }

    /**
     * Run test in Bitbar Cloud succeeded
     * 
     */
    public static Localizable _RUN_TEST_IN_CLOUD_SUCCEEDED() {
        return new Localizable(holder, "RUN_TEST_IN_CLOUD_SUCCEEDED");
    }

    /**
     * File not found
     * 
     */
    public static String ERROR_FILE_NOT_FOUND() {
        return holder.format("ERROR_FILE_NOT_FOUND");
    }

    /**
     * File not found
     * 
     */
    public static Localizable _ERROR_FILE_NOT_FOUND() {
        return new Localizable(holder, "ERROR_FILE_NOT_FOUND");
    }

    /**
     * Empty application path
     * 
     */
    public static String ERROR_APP_PATH() {
        return holder.format("ERROR_APP_PATH");
    }

    /**
     * Empty application path
     * 
     */
    public static Localizable _ERROR_APP_PATH() {
        return new Localizable(holder, "ERROR_APP_PATH");
    }

    /**
     * Bitbar Cloud (status)
     * 
     */
    public static String COLUMN_STATUS() {
        return holder.format("COLUMN_STATUS");
    }

    /**
     * Bitbar Cloud (status)
     * 
     */
    public static Localizable _COLUMN_STATUS() {
        return new Localizable(holder, "COLUMN_STATUS");
    }

    /**
     * Bitbar Cloud error
     * 
     */
    public static String ERROR_TESTDROID() {
        return holder.format("ERROR_TESTDROID");
    }

    /**
     * Bitbar Cloud error
     * 
     */
    public static Localizable _ERROR_TESTDROID() {
        return new Localizable(holder, "ERROR_TESTDROID");
    }

    /**
     * Success rate
     * 
     */
    public static String SUCCESS_RATE() {
        return holder.format("SUCCESS_RATE");
    }

    /**
     * Success rate
     * 
     */
    public static Localizable _SUCCESS_RATE() {
        return new Localizable(holder, "SUCCESS_RATE");
    }

    /**
     * Price
     * 
     */
    public static String PRICE() {
        return holder.format("PRICE");
    }

    /**
     * Price
     * 
     */
    public static Localizable _PRICE() {
        return new Localizable(holder, "PRICE");
    }

    /**
     * App Crawler
     * 
     */
    public static String APP_CRAWLER() {
        return holder.format("APP_CRAWLER");
    }

    /**
     * App Crawler
     * 
     */
    public static Localizable _APP_CRAWLER() {
        return new Localizable(holder, "APP_CRAWLER");
    }

    /**
     * "Error during get testRun({0,number,#}) by api."
     * 
     */
    public static String API_GET_TESTRUN_ERROR(Object arg1) {
        return holder.format("API_GET_TESTRUN_ERROR", arg1);
    }

    /**
     * "Error during get testRun({0,number,#}) by api."
     * 
     */
    public static Localizable _API_GET_TESTRUN_ERROR(Object arg1) {
        return new Localizable(holder, "API_GET_TESTRUN_ERROR", arg1);
    }

    /**
     * Failed to parse test timeout value: %s. Setting 10 minutes.
     * 
     */
    public static String TEST_TIMEOUT_NOT_NUMERIC_VALUE() {
        return holder.format("TEST_TIMEOUT_NOT_NUMERIC_VALUE");
    }

    /**
     * Failed to parse test timeout value: %s. Setting 10 minutes.
     * 
     */
    public static Localizable _TEST_TIMEOUT_NOT_NUMERIC_VALUE() {
        return new Localizable(holder, "TEST_TIMEOUT_NOT_NUMERIC_VALUE");
    }

    /**
     * Successful: %d; Failed: %d
     * 
     */
    public static String SUCCESS_RATE_DESCRIPTION() {
        return holder.format("SUCCESS_RATE_DESCRIPTION");
    }

    /**
     * Successful: %d; Failed: %d
     * 
     */
    public static Localizable _SUCCESS_RATE_DESCRIPTION() {
        return new Localizable(holder, "SUCCESS_RATE_DESCRIPTION");
    }

    /**
     * You have to set device group before running in the Cloud.
     * 
     */
    public static String NO_DEVICE_GROUP_CHOSEN() {
        return holder.format("NO_DEVICE_GROUP_CHOSEN");
    }

    /**
     * You have to set device group before running in the Cloud.
     * 
     */
    public static Localizable _NO_DEVICE_GROUP_CHOSEN() {
        return new Localizable(holder, "NO_DEVICE_GROUP_CHOSEN");
    }

    /**
     * "Check for testRun({0,number,#}) state."
     * 
     */
    public static String CHECK_FOR_TESTRUN_STATE(Object arg1) {
        return holder.format("CHECK_FOR_TESTRUN_STATE", arg1);
    }

    /**
     * "Check for testRun({0,number,#}) state."
     * 
     */
    public static Localizable _CHECK_FOR_TESTRUN_STATE(Object arg1) {
        return new Localizable(holder, "CHECK_FOR_TESTRUN_STATE", arg1);
    }

    /**
     * Instrumentation file %s does not differ from latest version in Cloud - not uploading
     * 
     */
    public static String INSTRUMENTATION_S_NOT_CHANGED_NOT_UPLOADING() {
        return holder.format("INSTRUMENTATION_S_NOT_CHANGED_NOT_UPLOADING");
    }

    /**
     * Instrumentation file %s does not differ from latest version in Cloud - not uploading
     * 
     */
    public static Localizable _INSTRUMENTATION_S_NOT_CHANGED_NOT_UPLOADING() {
        return new Localizable(holder, "INSTRUMENTATION_S_NOT_CHANGED_NOT_UPLOADING");
    }

    /**
     * Uploading new application file %s
     * 
     */
    public static String UPLOADING_NEW_APPLICATION_S() {
        return holder.format("UPLOADING_NEW_APPLICATION_S");
    }

    /**
     * Uploading new application file %s
     * 
     */
    public static Localizable _UPLOADING_NEW_APPLICATION_S() {
        return new Localizable(holder, "UPLOADING_NEW_APPLICATION_S");
    }

    /**
     * Uploading application file
     * 
     */
    public static String UPLOADING_APPLICATION() {
        return holder.format("UPLOADING_APPLICATION");
    }

    /**
     * Uploading application file
     * 
     */
    public static Localizable _UPLOADING_APPLICATION() {
        return new Localizable(holder, "UPLOADING_APPLICATION");
    }

    /**
     * Authorization ok.
     * 
     */
    public static String AUTHORIZATION_OK() {
        return holder.format("AUTHORIZATION_OK");
    }

    /**
     * Authorization ok.
     * 
     */
    public static Localizable _AUTHORIZATION_OK() {
        return new Localizable(holder, "AUTHORIZATION_OK");
    }

    /**
     * A problem occurred downloading results from Cloud: %s
     * 
     */
    public static String DOWNLOAD_RESULTS_FAILED_WITH_REASON_S() {
        return holder.format("DOWNLOAD_RESULTS_FAILED_WITH_REASON_S");
    }

    /**
     * A problem occurred downloading results from Cloud: %s
     * 
     */
    public static Localizable _DOWNLOAD_RESULTS_FAILED_WITH_REASON_S() {
        return new Localizable(holder, "DOWNLOAD_RESULTS_FAILED_WITH_REASON_S");
    }

    /**
     * Percentage of finished devices
     * 
     */
    public static String PROGRESS_TIP() {
        return holder.format("PROGRESS_TIP");
    }

    /**
     * Percentage of finished devices
     * 
     */
    public static Localizable _PROGRESS_TIP() {
        return new Localizable(holder, "PROGRESS_TIP");
    }

    /**
     * Connection error
     * 
     */
    public static String ERROR_CONNECTION() {
        return holder.format("ERROR_CONNECTION");
    }

    /**
     * Connection error
     * 
     */
    public static Localizable _ERROR_CONNECTION() {
        return new Localizable(holder, "ERROR_CONNECTION");
    }

    /**
     * There are no results for device %s. Test was not launched.
     * 
     */
    public static String NO_RESULT_FROM_DEVICE_TEST_WAS_NOT_LAUNCHED_S() {
        return holder.format("NO_RESULT_FROM_DEVICE_TEST_WAS_NOT_LAUNCHED_S");
    }

    /**
     * There are no results for device %s. Test was not launched.
     * 
     */
    public static Localizable _NO_RESULT_FROM_DEVICE_TEST_WAS_NOT_LAUNCHED_S() {
        return new Localizable(holder, "NO_RESULT_FROM_DEVICE_TEST_WAS_NOT_LAUNCHED_S");
    }

    /**
     * WAITING: %d / RUNNING: %d / FINISHED: %d / NUMBER OF DEVICES: %d
     * 
     */
    public static String PROGRESS_DESCRIPTION() {
        return holder.format("PROGRESS_DESCRIPTION");
    }

    /**
     * WAITING: %d / RUNNING: %d / FINISHED: %d / NUMBER OF DEVICES: %d
     * 
     */
    public static Localizable _PROGRESS_DESCRIPTION() {
        return new Localizable(holder, "PROGRESS_DESCRIPTION");
    }

    /**
     * Uploading instrumentation file
     * 
     */
    public static String UPLOADING_INSTRUMENTATION() {
        return holder.format("UPLOADING_INSTRUMENTATION");
    }

    /**
     * Uploading instrumentation file
     * 
     */
    public static Localizable _UPLOADING_INSTRUMENTATION() {
        return new Localizable(holder, "UPLOADING_INSTRUMENTATION");
    }

    /**
     * Problem with the Bitbar API. Please check email and password or contact support@bitbar.com
     * 
     */
    public static String ERROR_API() {
        return holder.format("ERROR_API");
    }

    /**
     * Problem with the Bitbar API. Please check email and password or contact support@bitbar.com
     * 
     */
    public static Localizable _ERROR_API() {
        return new Localizable(holder, "ERROR_API");
    }

    /**
     * Error downloading %s from %s
     * 
     */
    public static String ERROR_DURING_DOWNLOAD_S_FROM_S() {
        return holder.format("ERROR_DURING_DOWNLOAD_S_FROM_S");
    }

    /**
     * Error downloading %s from %s
     * 
     */
    public static Localizable _ERROR_DURING_DOWNLOAD_S_FROM_S() {
        return new Localizable(holder, "ERROR_DURING_DOWNLOAD_S_FROM_S");
    }

    /**
     * Run test in Bitbar Cloud failed
     * 
     */
    public static String RUN_TEST_IN_CLOUD_FAILED() {
        return holder.format("RUN_TEST_IN_CLOUD_FAILED");
    }

    /**
     * Run test in Bitbar Cloud failed
     * 
     */
    public static Localizable _RUN_TEST_IN_CLOUD_FAILED() {
        return new Localizable(holder, "RUN_TEST_IN_CLOUD_FAILED");
    }

    /**
     * Always
     * 
     */
    public static String ALWAYS() {
        return holder.format("ALWAYS");
    }

    /**
     * Always
     * 
     */
    public static Localizable _ALWAYS() {
        return new Localizable(holder, "ALWAYS");
    }

}
