/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins.remotesupport;

import com.testdroid.api.model.APIProject;
import com.testdroid.jenkins.Messages;
import com.testdroid.jenkins.TestdroidCloudSettings;
import com.testdroid.jenkins.remotesupport.MachineIndependentTask;
import com.testdroid.jenkins.utils.TestdroidApiUtil;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.RoleChecker;

public class MachineIndependentFileUploader
extends MachineIndependentTask
implements FilePath.FileCallable<Long> {
    private static final Logger LOGGER = Logger.getLogger(MachineIndependentFileUploader.class.getName());
    private FILE_TYPE fileType;
    private TaskListener listener;
    private long projectId;

    public MachineIndependentFileUploader(TestdroidCloudSettings.DescriptorImpl settings, long projectId, FILE_TYPE fileType, TaskListener listener) {
        super(settings);
        this.projectId = projectId;
        this.fileType = fileType;
        this.listener = listener;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
    }

    public Long invoke(File file, VirtualChannel vc) {
        Long result = null;
        int attempts = 3;
        do {
            try {
                TestdroidCloudSettings.DescriptorImpl settings = new TestdroidCloudSettings.DescriptorImpl(this);
                APIProject project = TestdroidApiUtil.createApiClient(settings).getUser().getProject(Long.valueOf(this.projectId));
                if (file.exists()) {
                    switch (this.fileType) {
                        case APPLICATION: {
                            result = project.uploadApplication(file, "application/octet-stream").getId();
                            break;
                        }
                        case TEST: {
                            result = project.uploadTest(file, "application/octet-stream").getId();
                            break;
                        }
                        case DATA: {
                            result = project.uploadData(file, "application/zip").getId();
                        }
                    }
                    continue;
                }
                this.listener.getLogger().println(String.format("%s: %s", Messages.ERROR_FILE_NOT_FOUND(), file.getAbsolutePath()));
                return null;
            }
            catch (Exception ex) {
                String message = String.format("Cannot upload file %s%s", file.getAbsolutePath(), attempts > 1 ? ". Will retry automatically" : "Won't be retried anymore");
                this.listener.getLogger().println(message);
                LOGGER.log(Level.WARNING, message, ex);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (result == null && --attempts > 0);
        return result;
    }

    public static enum FILE_TYPE {
        APPLICATION,
        TEST,
        DATA;

    }
}

