/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.jdk8;

import java.util.stream.Stream;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ser.std.StdSerializer;

public class Jdk8StreamSerializer
extends StdSerializer<Stream<?>> {
    private final JavaType elemType;
    private final transient ValueSerializer<Object> elemSerializer;

    public Jdk8StreamSerializer(JavaType streamType, JavaType elemType) {
        this(streamType, elemType, null);
    }

    public Jdk8StreamSerializer(JavaType streamType, JavaType elemType, ValueSerializer<Object> elemSerializer) {
        super(streamType);
        this.elemType = elemType;
        this.elemSerializer = elemSerializer;
    }

    @Override
    public ValueSerializer<?> createContextual(SerializationContext provider, BeanProperty property) {
        if (!this.elemType.hasRawClass(Object.class) && (provider.isEnabled(MapperFeature.USE_STATIC_TYPING) || this.elemType.isFinal())) {
            return new Jdk8StreamSerializer(provider.getTypeFactory().constructParametricType(Stream.class, this.elemType), this.elemType, provider.findContentValueSerializer(this.elemType, property));
        }
        return this;
    }

    @Override
    public void serialize(Stream<?> stream, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        try (Stream<?> s = stream;){
            g.writeStartArray(s);
            s.forEach(elem -> {
                if (this.elemSerializer == null) {
                    ctxt.writeValue(g, elem);
                } else {
                    this.elemSerializer.serialize(elem, g, ctxt);
                }
            });
            g.writeEndArray();
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, stream, g.streamWriteContext().getCurrentIndex());
        }
    }
}

