/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.std.StdSerializer;

@JacksonStdImpl
public class JDKStringLikeSerializer
extends StdSerializer<Object> {
    protected static final int TYPE_URL = 1;
    protected static final int TYPE_URI = 2;
    protected static final int TYPE_FILE = 3;
    protected static final int TYPE_PATH = 4;
    protected static final int TYPE_CLASS = 5;
    protected static final int TYPE_CURRENCY = 6;
    protected static final int TYPE_LOCALE = 7;
    protected static final int TYPE_PATTERN = 8;
    private static final Map<Class<?>, Integer> _types = new HashMap();
    private final int _type;

    public JDKStringLikeSerializer(Class<?> handledType, int type) {
        super(handledType);
        this._type = type;
    }

    public static final ValueSerializer<?> find(Class<?> raw) {
        Integer I = _types.get(raw);
        if (I == null) {
            return null;
        }
        return new JDKStringLikeSerializer(raw, I);
    }

    @Override
    public boolean isEmpty(SerializationContext prov, Object value) {
        return value.toString().isEmpty();
    }

    @Override
    public void serialize(Object value, JsonGenerator g, SerializationContext provider) throws JacksonException {
        g.writeString(switch (this._type) {
            case 3 -> ((File)value).getAbsolutePath();
            case 4 -> ((Path)value).toUri().toString();
            case 5 -> ((Class)value).getName();
            case 7 -> {
                Locale loc = (Locale)value;
                if (loc == Locale.ROOT) {
                    yield "";
                }
                yield loc.toLanguageTag();
            }
            default -> value.toString();
        });
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, this.handledType(), JsonToken.VALUE_STRING));
        this.serialize(value, g, ctxt);
        typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        this.visitStringFormat(visitor, typeHint);
    }

    static {
        _types.put(URL.class, 1);
        _types.put(URI.class, 2);
        _types.put(File.class, 3);
        _types.put(Path.class, 4);
        _types.put(Class.class, 5);
        _types.put(Currency.class, 6);
        _types.put(Locale.class, 7);
        _types.put(Pattern.class, 8);
    }
}

