/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jakarta.rs.cfg;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.cfg.MapperBuilder;

public abstract class MapperConfiguratorBase<IMPL extends MapperConfiguratorBase<IMPL, MAPPER>, MAPPER extends ObjectMapper> {
    private final ReentrantLock _lock = new ReentrantLock();
    protected EnumMap<MapperFeature, Boolean> _mapperFeatures;
    protected EnumMap<DeserializationFeature, Boolean> _deserFeatures;
    protected EnumMap<SerializationFeature, Boolean> _serFeatures;
    protected AnnotationIntrospector _instropectorOverride;
    protected MAPPER _mapper;
    protected MAPPER _defaultMapper;

    public MapperConfiguratorBase(MAPPER mapper, AnnotationIntrospector instropectorOverride) {
        this._mapper = mapper;
        this._instropectorOverride = instropectorOverride;
    }

    public MAPPER getDefaultMapper() {
        if (this._defaultMapper == null) {
            this._lock.lock();
            try {
                if (this._defaultMapper == null) {
                    this._defaultMapper = this._mapperWithConfiguration(this.mapperBuilder());
                }
            }
            finally {
                this._lock.unlock();
            }
        }
        return this._defaultMapper;
    }

    protected MAPPER mapper() {
        if (this._mapper == null) {
            this._lock.lock();
            try {
                if (this._mapper == null) {
                    this._mapper = this._mapperWithConfiguration(this.mapperBuilder());
                }
            }
            finally {
                this._lock.unlock();
            }
        }
        return this._mapper;
    }

    protected abstract MapperBuilder<?, ?> mapperBuilder();

    public MAPPER getConfiguredMapper() {
        return this._mapper;
    }

    public final void setMapper(MAPPER m) {
        this._mapper = m;
    }

    public final void setAnnotationIntrospector(AnnotationIntrospector aiOverride) {
        this._instropectorOverride = aiOverride;
    }

    public final void configure(DeserializationFeature f, boolean state) {
        if (this._deserFeatures == null) {
            this._deserFeatures = new EnumMap(DeserializationFeature.class);
        }
        this._deserFeatures.put(f, state);
    }

    public final void configure(SerializationFeature f, boolean state) {
        if (this._serFeatures == null) {
            this._serFeatures = new EnumMap(SerializationFeature.class);
        }
        this._serFeatures.put(f, state);
    }

    protected MAPPER _mapperWithConfiguration(MapperBuilder<?, ?> mapperBuilder) {
        return (MAPPER)this._builderWithConfiguration(mapperBuilder).build();
    }

    protected MapperBuilder<?, ?> _builderWithConfiguration(MapperBuilder<?, ?> mapperBuilder) {
        if (this._instropectorOverride != null) {
            mapperBuilder = mapperBuilder.annotationIntrospector(this._instropectorOverride);
        }
        if (this._mapperFeatures != null) {
            for (Map.Entry<MapperFeature, Boolean> entry : this._mapperFeatures.entrySet()) {
                mapperBuilder = mapperBuilder.configure(entry.getKey(), entry.getValue().booleanValue());
            }
        }
        if (this._serFeatures != null) {
            for (Map.Entry<MapperFeature, Boolean> entry : this._serFeatures.entrySet()) {
                mapperBuilder = mapperBuilder.configure((SerializationFeature)entry.getKey(), entry.getValue().booleanValue());
            }
        }
        if (this._deserFeatures != null) {
            for (Map.Entry<MapperFeature, Boolean> entry : this._deserFeatures.entrySet()) {
                mapperBuilder = mapperBuilder.configure((DeserializationFeature)entry.getKey(), entry.getValue().booleanValue());
            }
        }
        return mapperBuilder;
    }
}

